@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="/resources/assets/css/spintags-view.css?v={{time()}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<style>
#spintag tr th:nth-child(3), #spintag tr td:nth-child(3) {
    max-width: 300px;
    min-width: 220px;
}
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
<script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
<script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/common.js" type="text/javascript"></script>
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script>
    var objTable;
    var record_type = 'our_records';
    $(document).ready(function() {
        $(".btn-clone").click(function() {
            var id = $(this).attr("id");
            $.ajax({
                url: "{{ route('spintag.copy','') }}/"+id,
                type: "PUT",
                beforeSend: function ()
                {
                    $(".blockUI").show();
                },
                success: function(result) {
                    setTimeout(() => {
                        $(".blockUI").hide();
                        if(result.status=='fail')
                            Command: toastr["error"] (result.message);
                        else {
                            Command: toastr["success"](result.message);
                            $("#all_templates_modal").modal("hide");
                            table.draw();
                        }

                    }, 1000);
                }
            });

        });

        $("#clone_all").click(function() {
            $.ajax({
                url: "{{ route('spintag.copyAll') }}",
                type: "POST",
                beforeSend: function ()
                {
                    $(".blockUI").show();
                },
                success: function(result) {
                    setTimeout(() => {
                        $(".blockUI").hide();
                        if(result.status=='fail')
                            Command: toastr["error"] (result.message);
                        else {
                            Command: toastr["success"](result.message);
                            $("#all_templates_modal").modal("hide");
                            table.draw();
                        }

                    }, 1000);
                }
            });
        });

        $(document).on('change',"#show_to_user",function(){
             var id= $(this).data('id');
             $(".blockUI").show();
             setTimeout(() => {
                $(".blockUI").hide();
                Command: toastr["success"] ("Operation Successfull"); 
             }, 1500); 
             
        });

        $(".use-template").click(function() {
            $(".blockUI").show();
            setTimeout(() => {
                $(".blockUI").hide();
                $("#templates_modal").modal("hide");
                Command: toastr["success"] ("Tag successfully added!");
                setTimeout(() => {
                    location.reload();
                }, 1500);
            }, 1500);
        });
            
        $("a#help-article").css("display", "block");
        $("a#help-article").attr("href", "https://docs.mumara.com/Campaigns/Campaigns/Spintags");
        $("#spin_templates").DataTable({
            "aoColumnDefs": [{"bSortable": false, "aTargets": [2]}],
            "bProcessing": true,
            "aaSorting": [[0, "asc"]],
            "sPaginationType": "full_numbers",
            "pageLength" : "5",
            "aLengthMenu": [[5, 10, 50, 100, 500], [5, 10, 50, 100, 500]]
        });
        // function in master2 layout
        var page_limit=show_per_page('','spintag_pageLength',10);  // Params (table,page,default_limit=10)
        var table=$('#spintag').DataTable({
            "aoColumnDefs": [{"bSortable": false, "aTargets": [0,2,4]}],
            "bProcessing": true,
            "bServerSide": true,
            "aaSorting": [[3, "desc"]],
            "sPaginationType": "full_numbers",
            "sAjaxSource": "{{ url('/getSpintags') }}",
            "pageLength" : page_limit,
            "fnServerParams": function (aoData) {
                aoData.push({"name": "record_type", "value": record_type});
                aoData.push({"name": "clients", "value": $("#clients").val()});
                aoData.push({"name": "admins", "value": $("#admins").val()});
            },
            "aLengthMenu": [[10, 50, 100, 500], [10, 50, 100, 500]]
        });
        objTable = table;
        page_limit=show_per_page(table,'spintag_pageLength');

    });
    // delete spintag
    function deleteSpintag(id) {
        Swal.fire({
            title: "",
            text: "{{trans('common.message.alert_delete')}}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            cancelButtonText: "Cancel",
            confirmButtonText: "Yes Delete!",
        }).then((result) => {
            if (result.isConfirmed) {
                $("#row_"+id).attr("style", "display:none");
                $.ajax({
                    url: "{{ url('/') }}"+'/spintag/'+id,
                    type: "DELETE",
                    success: function(result) {
                        if(result == 'delete') {
                            Swal.fire({
                                text: "{{trans('common.message.delete')}}",
                                icon: "success",
                                showConfirmButton: false,
                                closeClick: false,
                                timer: 2000
                            });
                        }
                    }
                });
            }
        });
    }
    // delete selected spintag
    function deleteAll () {
        if(!$('input:checkbox:checked').length){
           alert('{{trans('common.message.alert_no_record')}}');
           Swal.fire({
                text: "{{trans('common.message.alert_no_record')}}",
                icon: "warning",
                showConfirmButton: false,
                closeClick: false,
                timer: 2000
            });
           return false;
        }
        Swal.fire({
            title: "",
            text: "{{trans('common.message.alert_delete')}}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            cancelButtonText: "Cancel",
            confirmButtonText: "Yes Delete!",
        }).then((result) => {
            if (result.isConfirmed) {
                $(".blockUI").show();
                var spintags = $('input:checkbox:checked').map(function() {
                    return this.value;
                }).get();
                $.ajax({
                    type    : "Delete",
                    url: "{{ url('/') }}"+'/spintag/'+spintags,
                    data    : {ids: spintags},
                    success: function(result) {
                        if(result == 'delete') {
                            $(".blockUI").hide();
                            Swal.fire({
                                text: "{{trans('common.message.delete')}}",
                                icon: "success",
                                showConfirmButton: false,
                                closeClick: false,
                                timer: 2000
                            });
                            window.location.href = "{{route('spintag.index')}}";
                        }
                    }
                });


            }
        });

    }
</script>
    @include('includes.view-pages-filter-script')
@endsection

@section(decide_content())
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="vImslclh">
    {{ Session::get('msg') }}
</div>
@endif
<div id="msg" class="display-hide" data-name="MMdZaaxz">
    <button class="close" data-close="alert"></button>
    <span id='msg-text' class="alert-text"><span>
</div>
<div class="row" data-name="WcNBieyo">
    <div class="col-md-12" data-name="XmpxcKeQ">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid" data-name="JHBkYrYy">
            <div class="kt-portlet__body" data-name="ryjVLgtd">
                <div class="table-toolbar" data-name="slIdLFad">
                    <div class="form-group row" data-name="rVNLHXmd">
                        <div class="col-md-12" data-name="ZsiERIPI">
                           @if(routeAccess('spintag.create'))
                            <div class="btn-group" data-name="xZOwbdmu">
                                <a href="{{ route('spintag.create') }}">
                                <button id="sample_editable_1_new" class="btn btn-label-success">
                                    <i class="la la-plus"></i> {{trans('common.form.button.add_new')}} 
                                </button></a>
                            </div>
                            @endif
                            @if(!$admin && routeAccess('clone_spintag') && count($templates)>0)
                            <div class="btn-group" data-name="CIIwjeJb">
                                <button class="btn btn-label-success" data-toggle="modal" data-target="#all_templates_modal">
                                    @lang('spintag.view.button.templates')
                                </button>
                            </div>
                            @endif
                            @if($admin)
                            <div class="btn-group" data-name="CIIwjeJb">
                                <a href="{{ route('spintag.templates') }}">
                                    <button class="btn btn-label-success">
                                        @lang('spintag.templates.button.defined_templated')
                                    </button>
                                </a>
                            </div>
                                @endif

                             @if(routeAccess('spintag.destroy'))
                            <div class="btn-group pull-right" data-name="moCsUQYT">
                                <button class="btn btn-label-info dropdown-toggle" data-toggle="dropdown">
                                    {{ trans('common.button.bulk_actions') }}
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a href="javascript:;" onclick="deleteAll();" class=""> <i class="fa fa-remove"></i> {{trans('common.form.button.delete')}}  </a>
                                    </li>
                                </ul>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                @include('includes.view-pages-filter')
                <div class="table-scrollable">
                    <table class="table table-striped table-hover table-checkable" id="spintag" role="grid" >
                        <thead>
                            <tr role="row">
                                <th style="width: 25px;">
                                    <label class="kt-checkbox kt-checkbox--single kt-checkbox--all kt-checkbox--solid">
                                        <input type="checkbox" class="checkboxes checkbox-all-index" autocomplete="off">
                                        <span></span>
                                    </label>
                                </th>
                                <th>{{trans('spintag.view.table_heading.tag')}}</th>
                                <th>{{trans('spintag.view.table_heading.description')}}</th>
                                <th>{{trans('spintag.view.table_heading.added_on')}}</th>
                                <th>{{trans('common.table_heading.actions')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

<div class="modal fade" id="all_templates_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Spintags Templates</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                </button>
                @if(count($templates)>0)
                <button class="btn btn-info btn-sm" id="clone_all">
                    Clone All
                </button>
                @endif
            </div>
            <div class="modal-body">
                <div class="temp-head">
                    <div class="tags">Tag</div>
                    <div class="desc">Description</div>
                    <div class="acts">Actions</div>
                </div>
                <div class="temp-blk scroll">
                    @foreach($templates as $template)
                    <div class="temp-row">
                        <div class="tags">{{$template->place_holder}}</div>
                        <div class="desc">{{$template->description}}</div>
                        <div class="acts">
                            <button class="btn btn-info btn-sm btn-clone" id="{{$template->id}}" type="button">Clone</button>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

@endsection