@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')

<link href="/resources/assets/css/custom-fields-view.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<style>
#custom-fields tr th, #custom-fields tr td {
    width: 140px !important;
}
table#custom-fields tr td:first-child, table#custom-fields tr th:first-child {
    width: 280px !important;
}
</style>
@endsection

@section('page_scripts')
    <script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
    <script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/common.js" type="text/javascript"></script>
    <script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
    <script>
        var objTable;
        var record_type = 'our_records';
        $(document).ready(function () {
            $("a#help-article").css("display", "block");
            $("a#help-article").attr("href", "https://support.mumara.com/hc/categories/1/4/getting-started");
            // function in master2 layout
            var page_limit = show_per_page('', 'cf_pageLength', 9);  // Params (table,page,default_limit=10)
            var table = $('#custom-fields').DataTable({
                "aoColumnDefs": [{"bSortable": false, "aTargets": [2,3,6]}],
                "bProcessing": true,
                "bServerSide": true,
                "aaSorting": [[5, "desc"]],
                "sPaginationType": "full_numbers",
                "sAjaxSource": "{{ url('/getProfileFields') }}",
                "pageLength": page_limit,
                "aLengthMenu": [[10, 50, 100, 500], [10, 50, 100, 500]],
                "fnPreDrawCallback": function (sAjaxSource) {
                    //   console.log(sAjaxSource);
                    if (sAjaxSource._iRecordsTotal == 0) {
                        //$(".subscribers-tbl-ajax").hide();
                    } else {
                        ///        $(".subscribers-tbl-ajax").show();
                    }
                },
            });
            objTable = table;
            page_limit = show_per_page(table, 'cf_pageLength');

        });

        // delete custom field function
        function deleteProfileField(id) {
                        Swal.fire({
                            title: "",
                            text: "{{trans('profile_fields.view.delete_field.alert_title')}}",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#d33',
                            cancelButtonColor: '#3085d6',
                            cancelButtonText: "Cancel",
                            confirmButtonText: "Yes Delete!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{ route('profileFields.destroy','') }}/" + id,
                                    type: "DELETE",
                                    data: {'force': 1},
                                    success: function (result) {
                                        Swal.fire({
                                            text: "{{trans('profile_fields.view.delete_field.alert_message')}}",
                                            icon: "success",
                                            showConfirmButton: false,
                                            closeClick: false,
                                            timer: 2000
                                        })
                                        objTable.draw();
                                    }
                                });

                            }
                        });
        }

        function changeStatus(id) {
            $('.blockUI').show();
            $.ajax({
                type   : "PUT",
                url    : "{{ route('profileFields.update','') }}/"+id,
                data: {'change_status': 1},
                success: function(result) {
                    $('.blockUI').hide();
                    if(result == "success")
                        Command: toastr["success"] ('{{trans('profile_fields.view.success_message.change_status')}}');
                    else
                        Command: toastr["error"] ('{{trans('trigger.view.error_message.change_status')}}');
                }
            });
        }

        $(document).ready(function() {



            $(".delete-list").click(function() {
                var check = $(this).is(":checked");
                if(check === true) {
                    $("#deleteItem").removeAttr("disabled");
                } else {
                    $("#deleteItem").attr("disabled", "disabled");
                }
            });
            $(".delete-list2").click(function() {
                var check = $(this).is(":checked");
                if(check === true) {
                    $("#deleteItem").removeAttr("disabled");
                } else {
                    $("#deleteItem").attr("disabled", "disabled");
                }
            });
        });
    </script>

    @include('includes.view-pages-filter-script')
@endsection
@section(decide_content())

    <!-- will be used to show any messages -->
    @if (Session::has('msg'))
        <div class="alert alert-success" data-name="VbGHZFMf">
            {{ Session::get('msg') }}
        </div>
    @endif
    <div id="msg" class="display-hide" data-name="wuciFdae">
        <button class="close" data-close="alert"></button>
        <span id='msg-text'><span>
    </div>
    <div class="row" data-name="UKaChrmV">
        <div class="col-md-12" data-name="jzdJeknz">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="kt-portlet kt-portlet--height-fluid" data-name="lMSeNHuL">
                <div class="kt-portlet__body" data-name="NcZctTie">
                    <div class="table-toolbar" data-name="vRJjWcLs">
                        <div class="form-group row" data-name="RCqDLbdE">
                            <div class="col-md-12" data-name="fottQcCk">
                                @if (routeAccess('profileFields.create'))
                                    <div class="btn-group" data-name="uUREPBjU">
                                        <a href="{{ route('profileFields.create') }}">
                                            <button id="sample_editable_1_new" class="btn btn-label-success">
                                                <i class="la la-plus"></i> {{trans('common.form.button.add_new')}}
                                            </button>
                                        </a>
                                    </div>
                                @endif
                               {{-- @if (routeAccess('fields.destroy'))
                                    <div class="btn-group pull-right" data-name="mGPmTciy">
                                        <button class="btn btn-label-info dropdown-toggle" data-toggle="dropdown">
                                            {{ trans('common.button.bulk_actions') }}
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-right">

                                            <li>
                                                <a href="javascript:;" onclick="deleteAll();" class=""> <i
                                                            class="la la-close"></i> {{trans('common.form.button.delete')}}
                                                </a>
                                            </li>

                                        </ul>
                                    </div>
                                @endif--}}
                            </div>
                        </div>
                    </div>
                    <div class="table-scrollable">
                        <table class="table table-striped table-hover table-checkable" id="custom-fields"
                            role="grid">
                            <thead>
                            <tr role="row">
                                <th>{{trans('profile_fields.view.title.table_headings.name')}}</th>
                                <th>{{trans('profile_fields.view.title.table_headings.sorting_order')}}</th>
                                <th>{{trans('profile_fields.view.title.table_headings.status')}}</th>
                                <th>{{trans('profile_fields.view.title.table_headings.type')}}</th>
                                <th>{{trans('profile_fields.view.title.table_headings.required')}}</th>
                                <th>{{trans('common.table_heading.created_on')}}</th>
                                <th>{{trans('common.table_heading.actions')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
    <!--Delete modal-->
    <div id="deleteMe" class="modal deleteMe" role="dialog" aria-hidden="true" data-keyboard="false"
         data-backdrop="static" data-name="dUYpphtk">
        <div class="modal-dialog modal-dialog-centered modal-lg" style="width: 600px;" data-select2-id="13" data-name="GFioYzVb">
            <div class="modal-content" data-select2-id="12" data-name="JJWvkHWS">
                <div class="modal-header" data-name="hVxuPKRo">
                <h5 id="mdlTitle" class="modal-title"></h5>
                </div>
                <div class="modal-body" data-name="gbkdXWDM">
                    <div class="row" data-name="JDrCwZwv" style="display:none">
                        <div class="col-md-12" data-name="TGaZsong">
                            <span class="alert-delete-message" id="itemToDelete"></span>
                        </div>
                    </div>
                    <div class="issue-1 fs-5 fw-bold mb1">{{trans('custom_fields.view.model_delete.label.issue_1')}}</div>
                    <div class="issue-2 fs-5 fw-bold mb1">{{trans('custom_fields.view.model_delete.label.issue_2')}}</div>
                    
                    <span class="alert alert-warning issue-1">
                        <span class="alert-text">{!!trans('custom_fields.view.model_delete.alert_warning.message_1')!!}</span>
                    </span>
                    <span class="alert alert-warning issue-2">
                        <span class="alert-text">{!!trans('custom_fields.view.model_delete.alert_warning.message_2')!!}</span>
                    </span>

                    <div id="domain-data" class="issue-1" data-name="oyaHdXQR">
                        <div class="list-block" data-name="bDplkoVS">
                            <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">

                            </div>
                        </div>
                    </div>

                    <div class="delete-options issue-1" data-name="oyaHdXQR">
                        <div class=" col-md-12">
                            <label class="col-form-label">{{trans('common.table_heading.actions')}}</label>
                            <p>{{trans('custom_fields.view.model_delete.action_description')}}</p>
                            <div class="kt-checkbox-list mb2">
                                <label class="kt-checkbox kt-checkbox-outline">
                                    <input class="delete-list" type="checkbox" autocomplete="off" id="unassign" name="unasign" />
                                    {{trans('custom_fields.view.model_delete.action_description_check')}}
                                    <span></span>
                                </label>
                            </div>
                            <span class="alert alert-info mb0">
                                <span class="alert-text">{!!trans('custom_fields.view.model_delete.action_alert_message')!!}</span>
                            </span>
                        </div>
                    </div>

                    <div class="delete-options issue-2" data-name="oyaHdXQR">
                        <div class=" col-md-12">
                            <div class="kt-checkbox-list">
                                <label class="kt-checkbox kt-checkbox-outline">
                                    <input class="delete-list2" type="checkbox" autocomplete="off" id="understand" name="understand" />
                                    {{trans('custom_fields.view.model_delete.data_flush_check')}}
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="modal-footer" data-name="lCYRZcBU">
                    <button type="button" class="btn btn-secondary btn-sm pull-left" data-dismiss="modal">{{trans('common.form.button.cancel')}}</button>
                    <button  type="button" class="btn btn-danger btn-sm pull-right" id="deleteItem" disabled>{{trans('custom_fields.view.model_delete.button_delete')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection