@extends(decide_template())

@section('title', $title)

@section('page_styles')
<link href="/resources/assets/css/custom-fields-create.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/jquery.nestable.css" rel="stylesheet" type="text/css" />
<style>
    .error{
        color: #FF0000;
    }
    .edit.readonly .select2-container {
        pointer-events: none;
    }
    .form-group.row .kt-switch.mt0 {
        margin-top: 0 !important;
    }
    .dd3-content {
        margin: 7px 0;
        background: #f9f9f9;
    }
    .dd3-content {
        height: 34px;
    }
    .dd-handle {
        height: 34px;
    }

    .dd3-handle {
        width: 34px;
        background: #eee;
    }
    .dd-handle, .dd3-content {
        -webkit-border-radius: 0px;
        border-radius: 0px;
    }
    .dd3-handle:before {
        content: '≡';
        top: 6px;
        color: #999;
    }
    .dd3-content .kt-checkbox-list {
        padding-left: 9px;
        margin-top: 1px;
    }
    .dd3-content .kt-checkbox-list, .dd3-content .mt-radio-list {
        padding: 0;
    }
    .kt-checkbox-list .kt-checkbox:last-child {
        margin-bottom: 0;
        margin-top: 1px;
    }
    .dd3-content label {
        margin: 0 !important;
        padding: 0 !important;
        margin-left: 5px !important;
    }
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
<script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
<script src="/themes/default/js/init.js" type="text/javascript"></script>
<script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
<script src="/themes/default/js/lib.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.input.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.nestable.js" type="text/javascript"></script>
<script>
   var form_error="{{trans('common.message.form_error')}}";
   var forbidden_error="{{trans('custom_fields.form.alert.forbidden_error')}}";

    var list_count_id = 0;
    var lists_ids = [];

    $(document).ready(function() {

        $("#sync_fields").click(function() {
            if($(this).prop("checked") == true){
                $(".check-custom-message").slideDown();
            }
            else if($(this).prop("checked") == false){
                $(".check-custom-message").slideUp();
            }
        }); 

        $('.m-select2').select2({
            placeholder: "Select option",
            templateResult: function (data, container) {
                if (data.element) {
                    $(container).addClass($(data.element).attr("class"));
                }
                return data.text;
            }
        });
        setInterval(function () {
            if (list_count_id == 1) {
                getSegmentCountStatus('get_status',lists_ids);
            }
        }, 5000);
        $("#counting").click(function() {
            $.each($("input[name='lists[]']"), function(){            
                lists_ids.push($(this).val());
            });
            if(list_count_id>0){
                $(".countsload").show();
                $(".counts").hide();
                $("a.button-next").attr("disabled", "disabled");
                $("#counting").attr('disabled',true);
                getSegmentCountStatus('count_status',lists_ids);
            }
        });
    });

    // $(document).ready(function () {
    //     function updateOutput(e) {
    //         var list = e.length ? e : $(e.target), output = list.data('output');
    //         if (window.JSON) {output.val(window.JSON.stringify(list.nestable('serialize')));//, null, 2));
    //         } else {
    //             output.val('JSON browser support required for this demo.');
    //         }
    //         //console.log(list.nestable('serialize'));

    //         console.log(window.JSON.stringify(list.nestable('serialize')));
    //         $.ajax({
    //             url: "{{ route('fields.sort_group','') }}/",
    //             type: "Get",
    //             data: {'field_order': window.JSON.stringify(list.nestable('serialize')) },
    //             success: function (result) {
    //                 console.log(result);
    //                 if(result.status=='success'){
    //                     Command: toastr["success"]("{{trans('Sorted order successfully')}}");
    //                 }
    //                 else {
    //                     Command: toastr["error"](result.message);
    //                 }
    //             }
    //         });
    //     };
    // $('#custom_groups').nestable({
    //         group: 1,
    //         maxDepth: 7,
    //     }).on('change', updateOutput);
    //     updateOutput($('#custom_groups').data('output', $('#custom_groups-output')));
       
       
    // });

    $(document).ready(function() {
        var updateOutput = function(e) {
            var list   = e.length ? e : $(e.target),
                output = list.data('output');
            if (window.JSON) {
                // output.val(window.JSON.stringify(list.nestable('serialize')));//, null, 2));
                $.ajax({
                    url: "{{ route('fields.sort_group','') }}/",
                    type: "Get",
                    data: {'field_order': window.JSON.stringify(list.nestable('serialize')) },
                    success: function (result) {
                        console.log(result);
                        if(result.status=='success'){
                            Command: toastr["success"]("{{trans('Sorted order successfully')}}");
                        }
                        else {
                            Command: toastr["error"](result.message);
                        }
                    }
                });
            } else {
                output.val('JSON browser support required for this application.');
            }
        };
        // activate Nestable for list 1
        $('#custom_groups').nestable({
            group: 1
        }).on('change', updateOutput);

        //updateOutput($('#custom_groups').data('output', $('#nestable-output')));

    });
   
</script>
<script>
    var storeUrl = "{{route('fields.store')}}";
    var updateUrl = "{{route('fields.update','')}}/";
    var createUrl = "{{route('fields.create')}}";
    var indexUrl = "{{route('fields.index')}}";
    var editUrl = "{{route('fields.edit','|id|')}}/";
    var alphaError = "{{trans('custom_fields.form.label.name_alphabetic_error')}}";
    var mixError = "{{trans('custom_fields.form.label.name_space_error')}}";
</script>

<script src="/themes/default/js/custom_field.js?v={{time()}}" type="text/javascript"></script>
<script src="/themes/default/js/common.js" type="text/javascript"></script>

@endsection

@section(decide_content())

@if($errors->any())
    <!-- For PHP validations errors-->
    <div class="alert alert-danger" data-name="bJbCtNdC">
        @foreach($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="MFEASMeX">
    {{ Session::get('msg') }}
</div>
@endif
<!-- will be used to show any messages -->
<div id="msg" class="display-hide" data-name="wUlmFIlg">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>

<div class="row" data-name="GBoqGCEC">

<div class="col-md-6 create-form" data-name="EoUCWIdE">
    <!-- BEGIN FORM-->
    <form action="" method="POST" id="custom-field-frm" autocomplete="off" class="kt-form kt-form--label-right">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        @if($action == 'add')
            <input type="hidden" id="action" value="add">
        @else
            <input type="hidden" id="action" value="edit">
            <input name="_method" type="hidden" value="PUT">
            <input type="hidden" id="custom-field-id" value="{{$custom_field->id}}">
        @endif
        <div class="row" data-name="YkrXSidZ">
            <div class="kt-portlet kt-portlet--height-fluid" data-name="hgjVRQYJ">
                <div class="kt-portlet__head" data-name="vtaoGJDL">
                    <div class="kt-portlet__head-label" data-name="YlFWsCgb">
                        <h3 class="kt-portlet__head-title">{{trans('custom_fields.form_heading')}}</h3>
                    </div>
                </div>
                <div class="kt-portlet__body" data-name="KeStsiMD">
                    <div class="form-body" data-name="NsOreXMD">
                    <?php 
                            $authUser = getAuthUser();
                            $is_client = isClient($authUser);
                        ?>
                        @if(!$is_client)
                        <div class="form-group row" data-name="cpukMvhz">
                            <div class="col-md-12">
                                <label class="col-form-label text-left">
                                    {{trans('custom_fields.form.label.default')}}  
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.default_help')}}" data-original-title="{{trans('common.description')}}"></i>
                                </label>
                                <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success pl12 mt0">
                                    <label>
                                        <input type="checkbox" autocomplete="off" name="is_default" value="1" <?php echo isset($custom_field->is_default) && $custom_field->is_default==1 ? ' checked ' : ' ' ?> >
                                        <span></span>
                                    </label>
                                </span>
                            </div>                                                             
                        </div>
                        @endif
                        <div class="form-group row" data-name="QBDtKkOb">
                                
                            <div class="col-md-6" data-name="UJhsnPHj">
                                <label class="col-form-label">{{trans('custom_fields.form.label.name')}}
                                    <span class="required"> * </span>
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.name_description')}}" data-original-title="{{trans('common.description')}}"></i>
                                </label>
                                <div class="input-icon right" data-name="CunTCPpi">
                                    <input type="text" id="nameDB" name="name" class="form-control" value="{{isset($custom_field->name) ? $custom_field->name : '' }}" {{ isset($custom_field->is_default) && $custom_field->is_default == 1 ? 'readonly' : '' }} {{ $action != 'add' ? 'readonly' : '' }} /> 
                                    <span id="nameDBError" class="error" style="display: none;">{{trans('custom_fields.form.label.name_error_message')}}</span>
                                </div>
                            </div>
                            <div class="col-md-6" data-name="mQVHIPDu">
                                <label class="col-form-label">{{trans('contact_list.form.label.group')}}
                                    @if(!$adminOnClient)
                                    <span   data-toggle="tooltip"  title="{{trans('contact_list.form.label.new_group')}}" ><a href="#modal-group-label" data-toggle="modal"><i class="fa fa-plus-square text-success"></i></a></span>
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('contact_list.form.label.group_description')}}" data-original-title="{{trans('common.description')}}"></i>

                                    @endif
                                </label>
                                <select class="form-control m-select2" data-placeholder="{{trans('contact_list.form.label.choose_group')}}" name="group_id" id="group-id">
                                    <!-- <option value="">{{trans('contact_list.form.label.choose_group')}}</option> -->
                                    @foreach($groups as $group)
                                            <option value="{{ $group->id }}" {{ (isset($custom_field->group_id) && $custom_field->group_id == $group->id) ? 'selected' : ''  }}>{{ $group->name }}</option>
                                        @endforeach
                                </select>
                            </div>
                            <div class="col-md-6" data-name="ibVmdPco">
                                <label class="col-form-label">{{trans('custom_fields.form.label.field_order')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.field_order_help')}}" data-original-title="{{trans('common.description')}}"></i>
                                </label>
                                <div class="input-icon right" data-name="RXBIGNaJ">
                                    <input type="text" name="field_order" class="form-control" value="{{isset($custom_field->field_order) ? $custom_field->field_order : '' }}" />
                                </div>
                            </div>
                            <div class="col-md-6" data-name="NoPqNVWY">
                                <label class="col-form-label" >{{trans('custom_fields.form.label.required')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.required_help')}}" data-original-title="{{trans('common.description')}}"></i>

                                </label>
                                <select class="form-control" name="is_required">
                                    <option value="0" {{(isset($custom_field->is_required)  && $custom_field->is_required == 0) ? 'selected' : '' }}>
                                        {{trans('common.form.button.no')}}
                                    </option>
                                    <option value="1" {{(isset($custom_field->is_required)  && $custom_field->is_required == 1) ? 'selected' : '' }}>
                                        {{trans('common.form.button.yes')}}
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-6 edit {{ $action != 'add' ? 'readonly' : '' }}" data-name="ipPWVWEP">
                                <label class="col-form-label">{{trans('custom_fields.form.label.field_type')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.field_type_help')}}" data-original-title="{{trans('common.description')}}"></i>

                                </label>
                                <select class="form-control m-select2 {{ $action != 'add' ? 'readonly' : '' }}" name="type" id="type-id">
                                    @foreach($fields_type as $key => $value)
                                        <option value="{{ $key }}" {{(isset($custom_field->type)  && $custom_field->type == $key) ? 'selected' : '' }} >{{ $value }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- <div class="col-md-12" data-name="ibVmdPco">
                                <label class="col-form-label">{{trans('custom_fields.form.label.language')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.language_help')}}" data-original-title="{{trans('common.description')}}"></i>
                                </label>
                                <div class="input-icon right" data-name="RXBIGNaJ">
                                    <input type="text" name="language" class="form-control" value="{{isset($custom_field->language) ? $custom_field->language : '' }}" />
                                </div>
                        </div> -->
                        <div class="form-group row" id="list-of-values" data-name="nqKfmjer">
                            <div class="col-md-12" data-name="bHtWgpWY">
                                <label class="col-form-label">{{trans('custom_fields.form.label.list_of_values')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.list_of_values_help')}}" data-original-title="{{trans('common.description')}}"></i>

                                </label>
                                <div class="input-icon right" data-name="ADFUimeZ">
                                    <textarea name="options" class="form-control" rows="5" <?php echo isset($custom_field->id) && $custom_field->id == 6 ? ' readonly ' : ' '?> >{{isset($custom_field->options) ? $custom_field->options : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row" data-name="IjUwmEdI">
                                
                            <div class="col-md-12" data-name="JebvJaur">
                                <label class="col-form-label">
                                    {{trans('custom_fields.form.label.contact_list')}}
                                    <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('custom_fields.form.label.contact_list_help')}}" data-original-title="{{trans('common.description')}}"></i>
                                </label>
                                <div class="scroller scroll scroll-300 kt-checkbox-list" data-name="oflzVxbw">
                                    @foreach ($list_tree as $group_metadata)
                                        <div style="padding: 5px 0;" data-name="ZTACLmQL">
                                            <label class="kt-checkbox">
                                                <input class="group-selector-subscriber" type="checkbox" autocomplete="off" value="" id="{{ $group_metadata['id'] }}" name="list_group_tab1[]"> <strong>{{ $group_metadata['name'] }}</strong>
                                                <span></span>
                                            </label>
                                        </div>
                                        @foreach ($group_metadata['children'] as $list_metadata)
                                            <div style="padding-left: 20px;" data-name="DVmydzIO">
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" autocomplete="off" value="{{ $list_metadata['id'] }}" name="lists[]" class="group-subscriber-{{ $group_metadata['id'] }}" {{(isset($list_ids) && in_array($list_metadata['id'], $list_ids)) ? 'checked' : '' }}> {{ $list_metadata['name'] }}
                                                    <span></span>
                                                </label>
                                            </div>
                                        @endforeach
                                    @endforeach
                                </div>
                            </div>
                        </div>

                        <div class="form-group row mb0" data-name="ywyNhnXA">
                            <div class="col-md-12" data-name="lLrpiUEo">
                                <div class="kt-checkbox-list mt15" data-name="OQHXboGT">
                                    <label class="kt-checkbox">
                                        <input type="checkbox" autocomplete="off" value="1" name="sync_fields" id="sync_fields"> {{trans('custom_fields.form.label.check_list')}}
                                        <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('common.label.check_list_help')}}" data-original-title="{{trans('common.description')}}"></i>
                                        <span></span>
                                    </label>
                                </div>
                                <div class="check-custom-message text-danger" data-name="XcVVGtUl">
                                    <small><b>{{trans('common.form.note')}}</b>: {{trans('custom_fields.form.label.check_list_message')}}</small>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="kt-portlet__foot" data-name="WDctplmR">
                    <div class="row" data-name="FpWdVFbD">
                        <div class="col-md-12" data-name="WVtqGXZV">
                            @if($action == 'add')
                            <button type="submit" name="save_add" class="btn btn-success" value="save_exit">{{trans('common.form.button.save')}}</button>
                            @else
                            <button type="submit" name="edit" class="btn btn-success" value="edit">{{trans('common.form.button.save')}}</button>
                            @endif
                            <a href="{{ route('fields.index') }}"><button type="button" class="btn btn-default">{{trans('common.form.button.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- END FORM-->
</div>

<div class="col-md-6 create-form">
    <div id="custom_groups-output"></div>
	<div class="kt-portlet kt-portlet--height-fluid" style="display: block;">
		<div class="kt-portlet__head">
			<div class="kt-portlet__head-label">
				<h3 class="kt-portlet__head-title">
                    {{trans('custom_fields.form.label.prioritize_groups')}}
                </h3> 
            </div>
		</div>
		<div class="kt-portlet__body">
			<p>{{trans('custom_fields.form.label.prioritize_groups_desc')}}</p>
			<div class="form-group">
				<div class="dd" id="custom_groups">
					<ol class="dd-list" id="sortable">
                    @foreach($groups as $group)
						<li class="dd-item dd3-item" data-id="{{$group->id}}">
							<div class="dd-handle dd3-handle"> </div>
							<div class="dd3-content">
								<div class="kt-checkbox-list">
									<label data-id="{{$group->id}}" data-name="{{$group->name}}">
                                    {{$group->name}}
                                    </label>
								</div>
							</div>
						</li>
                    @endforeach
                    </ol>
				</div>
			</div>
		</div>
	</div>
</div>

</div>

<!-- show modal Add New Group  -->
<div id="modal-group-label" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-name="FkaxpRIW">
    <div class="modal-dialog" data-name="wfulBGGR">
        <div class="modal-content" data-name="AYgCVVuL">
            <div class="modal-header" data-name="VuRZoqpk">
                <h5 class="modal-title">{{trans('contact_list.form.label.new_group')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" data-name="KdrFdWsu">
                <div id="msg-group" class="display-hide" data-name="IWLdanis">
                    <span id='msg-text-group'></span>
                </div>
                <form action="" id="frm-group" method="post" class="kt-form kt-form--label-right" autocomplete="off">
                        <div class="form-group row" data-name="JKgbhKWC">
                            <label class="col-md-4 col-form-label" >{{trans('contact_list.form.label.group')}} </label>
                            <div class="col-md-7" data-name="RFXNabUC">
                                <input type="text" id="group_name"  name="name" class="form-control" required> 
                            </div>
                        </div>                
                    <div class="form-actions" data-name="fXdhSacX">
                        <div class="row" data-name="fltpqaAL">
                            <label class="col-md-4 col-form-label" ></label>
                            <div class="col-md-8" data-name="gNJcNCHT">
                                <button type="submit" class="btn btn-success">{{trans('common.form.button.submit')}}</button>
                                <button type="reset" class="btn btn-default">{{trans('common.form.button.reset')}}</button>
                                <input type="hidden" value="5" name="section_id">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
    <!-- show modal Add New Group  -->
@endsection