<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Web Forms";
$lang["view"]["description"] = "Create and manage online forms to capture leads, gather subscriber information, or collect feedback from your audience. Customize form fields, design layouts, and integrate with your email campaigns for seamless data collection and management.";
$lang["view"]["table_heading"]["name"] = "Form Name";
$lang["view"]["table_heading"]["double_option"] = "Require email confirmation";
$lang["view"]["table_heading"]["thank_you_action"] = "Thank You Email";
$lang["add"]["title"] = "Add Web Form";
$lang["add"]["description"] = "Create a new web form to capture leads, collect subscriber data, or gather audience feedback. Customize the form's fields, layout, and design to match your brand and objectives.";
$lang["form_heading"]["details"] = "Form Details";
$lang["form_heading"]["details_description"] = "Details and settings.";
$lang["form"]["label"]["form_name"] = "Form name";
$lang["form"]["label"]["form_name_description"] = "A descriptive name for your web form.";
$lang["form"]["label"]["double_option"] = "Require email confirmation";
$lang["form"]["label"]["double_option_description"] = "Enable to require new subscribers to confirm their email address before being added to your list.";
$lang["form"]["label"]["thankyou_email"] = "Send thank you email";
$lang["form"]["label"]["thankyou_email_description"] = "Enable to send a thank you email to new subscribers.";
$lang["form"]["label"]["email_new_contact_details"] = "Notification email";
$lang["form"]["label"]["email_new_contact_details_description"] = "Enter the email address where you'll receive notifications about new subscribers.";
$lang["form"]["label"]["format"] = "Email format";
$lang["form"]["label"]["format_description"] = "Choose the format of emails sent to new subscribers, or let them choose.";
$lang["form"]["label"]["duplicates_description"] = "Choose how to handle duplicate subscribers: skip them or update their information.";
$lang["form"]["format_option"]["allow_contacts_to_choose"] = "Allow subscribers to choose";
$lang["form"]["label"]["sending_nodes_description"] = "Select the sending node responsible for sending welcome/confirmation emails.";
$lang["form"]["label"]["contact_list_description"] = "Select the contact list and specific fields to store new subscriber data.";
$lang["form"]["label"]["select_fields"] = "Form fields";
$lang["form"]["label"]["select_fields_description"] = "Arrange the fields in the order you want them to appear on the web form.";
$lang["form"]["label"]["confirmation_action"] = "Redirect after submission";
$lang["form"]["label"]["confirmation_action_description"] = "<p>
<strong>Show confirmation page:</strong><br>
Redirect subscribers to the built-in confirmation page. <br>
<br>
<strong>Redirect to another webpage:</strong><br>
Enter the URL of the webpage where you want to redirect subscribers after they submit the form. 
</p>";
$lang["form"]["confirmatin_option"]["show_confirmation_page"] = "Show confirmation page";
$lang["form"]["thanks_option"]["take_contact_to_a_website"] = "Redirect to another webpage";
$lang["form"]["confirmatin_option"]["show_json_response"] = "Show JSON response";
$lang["form"]["label"]["confirmation_page_content"] = "Confirmation page content";
$lang["form"]["label"]["confirmation_page_content_description"] = "Customize the message displayed after successful submission when \"Require email confirmation\" option is disabled.";
$lang["form"]["label"]["confirmation_page_content_help_text"] = "You're almost subscribed!
We've sent a confirmation email to the address you provided. Please click the link inside to complete your subscription.
Thank you!";
$lang["form"]["update_page_input_value"]["content_text"] = "You're already subscribed! We've updated your information.";
$lang["form"]["label"]["confirmation_json_content_text"] = "Display a JSON response after form submission (for advanced users).";
$lang["form"]["label"]["website_address"] = "Website URL";
$lang["form"]["label"]["website_address_description"] = "Enter your website address.";
$lang["form"]["label"]["sender_name"] = "Sender name";
$lang["form"]["label"]["sender_name_description"] = "The name that will appear in confirmation and thank you emails.";
$lang["form"]["label"]["sender_email"] = "Sender email";
$lang["form"]["label"]["sender_email_description"] = "The email address that confirmation and thank you emails will appear to be sent from.";
$lang["form"]["label"]["reply_email"] = "Reply-to email";
$lang["form"]["label"]["reply_email_description"] = "The email address where subscriber replies will be sent.";
$lang["form"]["label"]["email_subject"] = "Email subject";
$lang["form"]["label"]["email_subject_description"] = "The subject line of the confirmation email. Default: \"Confirm your subscription!\"";
$lang["form"]["label"]["confirmation_email_html_content"] = "Confirmation email HTML content";
$lang["form"]["label"]["confirmation_email_html_content_description"] = "The HTML content of the confirmation email. Use %%confirmurl%% for the confirmation link and %%application_name%% for your application's name.";
$lang["form"]["label"]["confirmation_email_html_content_help_text"] = "<p>Dear Subscriber,</p>
<p>You're almost there! Just one click to confirm your subscription.</p>
<a href=\"%%confirmurl%%\" style=\"display: inline-block; padding: 10px 20px; background-color: #007bff; color: white; text-decoration: none; border-radius: 5px;\">Confirm   
Subscription</a>
<p>Or, copy and paste this link into your browser:</p>
<p>%%confirmurl%%</p>
<p>Best Regards,<br>
%%application_name%%</p>
<p style=\"font-size: smaller; color: #666;\">*This email was sent based on your request to subscribe. If you believe this is an error, you can disregard this email and unsubscribe.*</p>";
$lang["form"]["label"]["confirmation_email_text_content"] = "Confirmation email Text content";
$lang["form"]["label"]["confirmation_email_text_content_description"] = "The plain text content of the confirmation email. Use %%confirmurl%% for the confirmation link and %%application_name%% for your application's name.";
$lang["form"]["label"]["confirmation_email_text_content_help_text"] = "Dear Subscriber,

You're almost subscribed! To complete your subscription, please copy and paste the following link into your browser:

%%confirmurl%%

Best Regards,
%%application_name%%";
$lang["form"]["label"]["json_response_text_content"] = "JSON Response";
$lang["form"]["label"]["json_response_text_description"] = "The JSON response of the confirmation email.";
$lang["form"]["label"]["thank_you_email_action"] = "Redirect subscriber to";
$lang["form"]["label"]["thank_you_email_action_description"] = "<td>
    <strong>Show Thank You Page:</strong><br>
    Display the built-in thank you page after subscription.<br>
    <br>
    <strong>Redirect to Another Webpage:</strong><br>
    Redirect the subscriber to a different webpage after subscription.
</td>";
$lang["form"]["label"]["show_thank_you_page"] = "Show thank you page";
$lang["form"]["label"]["thankyou_page"] = "Thank you page content";
$lang["form"]["label"]["thankyou_page_text"] = "Welcome to the Community!

We're thrilled to have you join our contact list. Get ready for exciting updates, exclusive offers, and valuable insights delivered straight to your inbox.

We appreciate your interest and look forward to connecting with you soon!

Stay tuned!";
$lang["form"]["label"]["thankyou_page_description"] = "The content that you want your subscriber to see after subscription completion.";
$lang["form"]["label"]["thank_you_from_name"] = "Sender name";
$lang["form"]["label"]["thank_you_from_name_description"] = "The name that will appear as the sender of the thank you email.";
$lang["form"]["label"]["thank_you_from_email"] = "Sender email";
$lang["form"]["label"]["thank_you_from_email_description"] = "The email address from which the thank you email will be sent";
$lang["form"]["label"]["thank_you_reply_email"] = "Reply-to email";
$lang["form"]["label"]["thank_you_reply_email_description"] = "The email address where replies to the thank you email should be sent";
$lang["form"]["label"]["thank_you_email_subject"] = "Email subject";
$lang["form"]["label"]["thank_you_email_subject_description"] = "The subject line of the thank you email. Default: \"Thank you for your subscription!\"";
$lang["form"]["label"]["thank_you_reply_email_value"] = "Thank you for your subscription!";
$lang["form"]["label"]["thankyou_email_html_content"] = "Email HTML content";
$lang["form"]["label"]["thankyou_email_html_content_description"] = "The HTML content of the thank you email.";
$lang["form"]["label"]["thankyou_email_html_content_value"] = "<p>Dear Subscriber,</p>
<p>Your subscription is confirmed! We'll keep you in the loop with all the latest news, updates, and special offers.</p>
<p>Thanks again for joining us!</p>
<p>Best Regards,<br>
%%application_name%%</p>";
$lang["form"]["label"]["thankyou_email_text_content"] = "Email Text content";
$lang["form"]["label"]["thankyou_email_text_content_description"] = "The Text content of the thank you email.";
$lang["form"]["label"]["thankyou_email_content_text_value"] = "Dear Subscriber,

Your subscription is confirmed! We'll keep you updated with the latest news and offers.

Thank you,
%%application_name%%";
$lang["form"]["label"]["error_actions"] = "In case of an error";
$lang["form"]["label"]["error_actions_description"] = "<td>
<strong>Show error page:</strong><br>
Display the built-in error page if there's an issue with the subscription. <br>
<br>
<strong>Redirect to another web page:</strong><br>
Redirect the subscriber to a specified URL if an error occurs during subscription. 
</td>";
$lang["form"]["error_actions_option"]["show_error_page"] = "Show error page";
$lang["form"]["error_actions_option"]["take_the_contact_to_following_website"] = "Redirect to another web page";
$lang["form"]["label"]["error_page"] = "Error Page Content";
$lang["form"]["label"]["error_page_description"] = "The content displayed to the subscriber if an error occurs (only when 'Show error page' option is selected).";
$lang["form"]["label"]["error_page_value"] = "An error has occurred during the subscription:
 <br><br>
 %%error%%";
$lang["form"]["addional_field_dropdown"]["form_error"] = "Error";
$lang["add_new"]["form"]["system_variables"] = "System Variables";
$lang["form"]["addional_field_dropdown"]["today_date"] = "Date Today";
$lang["form"]["addional_field_dropdown"]["list_name"] = "List Name";
$lang["form"]["addional_field_dropdown"]["list_id"] = "List ID";
$lang["form"]["label"]["gcaptcha"] = "Google Recaptcha";
$lang["form"]["label"]["public_key"] = "Public Key";
$lang["form"]["label"]["secret_key"] = "Secret Key";
$lang["form"]["label"]["form_design"] = "Web form Templates";
$lang["form"]["design_id_option"]["select_webform_design"] = "Select a web form template.";
$lang["form"]["button"]["web_form_templates"] = "Templates";
$lang["form"]["link"]["change_template"] = "Change template";
$lang["form"]["button"]["confirmation"] = "Email Confirmation";
$lang["form_heading"]["confirmation"] = "Double opt-in settings.";
$lang["form_heading"]["thank_you"] = "Welcome Email";
$lang["form_heading"]["thank_you_description"] = "Welcome settings.";
$lang["form_heading"]["error"] = "Error";
$lang["form_heading"]["error_description"] = "If error occurs.";
$lang["form"]["label"]["form_design_description"] = "Select a template to apply to your web form.";
$lang["edit"]["title"] = "Edit Web Form";
$lang["edit"]["description"] = "Customize your web form to fit your needs. Update details, change sending nodes, modify content, and make any other necessary adjustments.";
$lang["form"]["dynamic_tags"]["title"] = "Dynamic Tags";
$lang["form"]["dynamic_tags"]["select_custom_variables"] = "Select Variables";
$lang["form"]["dynamic_tags"]["custom_fields"] = "Custom Fields";
$lang["form"]["dynamic_tags"]["tracking_domain"] = "Tracking Domain";
$lang["form"]["message"]["form_copied"] = "The web form has been duplicated successfully.";
$lang["form"]["alert_message"]["double_option"] = "\"Require email confirmation\" option was disabled, so these settings were not applied.";
$lang["form"]["error_message"]["file_not_found"] = "The file doesn't exist.";
$lang["update"]["notification"]["activity_title"] = "Web Form";
$lang["view"]["modal_heading"]["subscription_form"] = "Subscription Form";
$lang["view"]["table_heading"]["actions"]["open_form"] = "View Form";
$lang["view"]["table_heading"]["actions"]["get_html"] = "Get HTML";
$lang["form"]["label"]["form_html"] = "Web Form HTML";
$lang["form"]["label"]["admin_notification"] = "Send notification";
$lang["form"]["label"]["admin_notification_description"] = "Enable to send email notifications to the provided email address.";
$lang["templates"]["title"] = "Web Form Templates";
$lang["templates"]["description"] = "Browse and manage your collection of web form templates. Create new templates from scratch, customize existing ones, or choose from our pre-designed templates to streamline your form creation process and maintain consistency across your brand.";
$lang["templates"]["table_heading"]["name"] = "Template name";
$lang["templates"]["table_heading"]["view_template"] = "Thumbnail";
$lang["templates"]["table_heading"]["predefined"] = "Pre-built";
$lang["templates"]["delete_notification"]["activity_log"] = "Web form template deleted";
$lang["form"]["label"]["return_path"] = "Bounce email";
$lang["form"]["label"]["return_path_description"] = "Choose the email address where you want to receive notifications about failed email deliveries (bounces).";
$lang["form"]["label"]["subject_title_description"] = "The subject line for the email notification sent to the provided email address when a new subscriber is added through a web form.";
$lang["form"]["label"]["subject_title"] = "Notification email subject";
$lang["form"]["label"]["content_title_value"] = "<p>A new subscriber has been added to the list: %%list_name%% via the web form: %%webform_name%%.</p>
<p>You're receiving this email because you opted in to receive notifications for new web form submissions.</p>
<p>%%app_title%%</p>";
$lang["form"]["label"]["content_title_description"] = "The body of the email notification sent to the provided email address when a new subscriber is added through a web form.";
$lang["form"]["label"]["content_title"] = "Notification email content";
$lang["form"]["label"]["subject_title_value"] = "A new contact has been added";
$lang["templates"]["edit"]["title"] = "Edit web form template";
$lang["templates"]["add"]["title"] = "Add web form template";
$lang["templates"]["add"]["description"] = "Design and customize a new web form template to streamline your form creation process. Tailor the template's fields, layout, and appearance to match your branding and specific needs, ensuring consistency across multiple web forms.";
$lang["templates"]["form"]["label"]["name"] = "Template name";
$lang["templates"]["form"]["label"]["name_description"] = "Give this template a name for easy identification.";
$lang["templates"]["form"]["label"]["preview_picture"] = "Template preview picture";
$lang["templates"]["form"]["label"]["preview_picture_description"] = "Upload an image showcasing the template's appearance. ";
$lang["templates"]["form"]["label"]["form_type"] = "Form type";
$lang["templates"]["form"]["label"]["form_type_description"] = "Select the type of form this template will be used for.";
$lang["create_web_form_design"]["select"]["form_type"] = "Select the form type";
$lang["templates"]["form"]["label"]["name_validate_message"] = "Enter the template name.";
$lang["templates"]["form"]["label"]["category_id_validate_message"] = "Select the form type.";
$lang["templates"]["error_message"]["permission_not_allow"] = "Permission denied to upload the preview picture to the folder.";
$lang["templates"]["error_message"]["extension_fail"] = "Invalid file extension.";
$lang["templates"]["error_message"]["invalid_file"] = "Invalid file.";
$lang["templates"]["error_message"]["error_in_save"] = "Oops! There's a problem with the database connection.";
$lang["templates"]["success_message"]["saved_successfully"] = "Web form template saved successfully.";
$lang["templates"]["view"]["title"] = "Select Web Form Template";
$lang["templates"]["view"]["description"] = "Choose from our selection of pre-designed templates or design a custom web form template from scratch to streamline your form creation process.";
$lang["view_web_form_design"]["title"] = "Preview web form";
$lang["view_web_form_design"]["description"] = "See how your web form will look to visitors.";
$lang["make_copt_form_design"]["success"] = "Copied successfully!";
$lang["templates"]["view"]["table_heading"]["actions"]["copy"] = "Duplicate";
$lang["view"]["success_message"]["copy_url"] = "Post URL copied to clipboard.";
$lang["view"]["error_message"]["form_not_exist"] = "Web form not found.";
$lang["view"]["error_message"]["list_not_exist"] = "The list associated with this web form no longer exists.";
$lang["view"]["error_message"]["invalid_token"] = "Invalid token.";
$lang["view"]["error_message"]["insufficient_request_score"] = "Suspicious activity detected. Please try again later.";
$lang["view"]["success_message"]["redirection_url"] = "Subscription confirmed. You will now be redirected.";
$lang["view"]["alert_message"]["email_address_confirmed"] = "Email confirmed! Thank you for subscribing.";
$lang["view"]["error_message"]["setup_smtp_settings_exception"] = "Configure or update your SMTP settings in Mail settings.";
$lang["form"]["system_variable"]["title"] = "System Variables";
$lang["form"]["additional_variable"]["title"] = "Custom Variables";
$lang["template"]["form"]["label"]["supported_extensions_help_text"] = "Supported image formats: JPG, PNG, GIF. Recommended dimensions: 750px x 150px.";
$lang["template"]["form"]["label"]["html"] = "HTML";
$lang["template"]["modal_heading"]["web_template_preview"] = "Web form template preview";
$lang["view"]["success_message"]["variable_placed_successfully"] = "Variable inserted successfully!";
$lang["form"]["label"]["label_selected_template"] = "Current Template:";
$lang["form"]["link"]["cancel_change_template"] = "Cancel change";
$lang["form"]["modal"]["system_additional_variables_description"] = "Insert system or custom variables by clicking the corresponding button.";
$lang["form"]["modal_heading"]["system_additional_variables"] = "Additional Variables";
$lang["form"]["modal"]["variables"] = "Variables";
$lang["form"]["alert_message"]["no_template_added"] = "No templates available.";
$lang["v3"]["radio"] = "V3";
$lang["v2"]["radio"] = "V2";
$lang["template"]["form"]["label"]["search_template"] = "Search templates";
$lang["template"]["add"]["button"]["blank_template"] = "Blank Template";
$lang["template"]["add"]["button"]["use_this"] = "Use This";
$lang["template"]["table_heading"]["actions"]["preview"] = "Preview";
$lang["template"]["table_heading"]["actions"]["edit"] = "Edit";
$lang["template"]["add"]["title"] = "Add New";
$lang["template"]["edit"]["title"] = "Edit Template";
$lang["template"]["library"]["view"]["title"] = "Template Library";
$lang["template"]["library"]["view"]["description"] = "Explore and manage a collection of pre-designed web form templates to streamline your form creation process. Choose from various templates, customize them to match your brand, and easily incorporate them into your campaigns.";
$lang["template"]["access_denied"]["gate_closed"] = "Access Restricted";
$lang["template"]["access_denied"]["gate_closed_description"] = "This area requires specific permissions to access.";
$lang["template"]["access_denied"]["button_dashboard"] = "Return to Dashboard";
$lang["template"]["access_denied"]["title"] = "403 - Access Denied";
$lang["template"]["access_denied"]["heading"] = "Oops!";
$lang["template"]["view"]["title"] = "Web form templates";
$lang["template"]["form_heading"] = "Web form template Details";
$lang["template"]["form"]["label"]["choose_template"] = "Select a template";
$lang["template"]["form"]["label"]["page_html"] = "Page HTML";
$lang["template"]["form"]["button"]["save_template"] = "Save Template";
$lang["template"]["success_message"]["successfully_Updated"] = "Template updated successfully.";
$lang["template"]["error_message"]["something_went_wrong"] = "An error occurred. Please try again.";
$lang["template"]["form"]["page_html_description"] = "Enter your Page HTML in the source code editor below.";
$lang["template"]["form"]["template_name_description"] = "Give this template a name for easy identification.";
$lang["template"]["form"]["template_name_description_title"] = "Template Name";
$lang["template"]["success_message"]["template_successfully_deleted"] = "Template deleted successfully.";
$lang["template"]["error_message"]["web_templat_used"] = "This template is currently in use and cannot be deleted.";
$lang["template"]["view"]["bulk_actions_dropdown"]["delete_all"] = "Delete all";
$lang["template"]["view"]["table_heading"]["name"] = "Template Name";
$lang["template"]["view"]["table_heading"]["creation_date"] = "Created On";
$lang["template"]["not_found"]["heading"] = "Page not found.";
$lang["template"]["not_found"]["page_looking_not_found"] = "Sorry, but the page you are looking for is not found. Please double-check the URL.";
$lang["template"]["not_found"]["title"] = "404 - Page Not Found";
$lang["template"]["unsubscribed"]["title"] = "You have been unsubscribed.";
$lang["node"]["inactive"] = "The attached sending node is currently inactive. Please activate the sending node or choose a different one.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
