<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Triggers";
$lang["view"]["description"] = "Set up automated actions that are executed when specific events occur, such as when a contact is added to a list or segment, or when a profile field is updated. Triggers allow you to run actions like sending emails or updating data based on these conditions, helping to automate your workflows and ensure timely responses.";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["view"]["table_heading"]["trigger_action"] = "Actions Performed";
$lang["view"]["table_heading"]["last_activity"] = "Last Activity";
$lang["add"]["title"] = "Add Trigger";
$lang["add"]["description"] = "Create a new automated action based on specific events, such as adding a contact to a list or updating a profile field. Define the conditions that will activate the trigger and choose the actions to be executed, automating your workflows and ensuring efficient task management.";
$lang["form_heading"]["setup"] = "Event";
$lang["form_heading"]["setup_description"] = "Define an event";
$lang["form"]["label"]["status"] = "Status";
$lang["form"]["label"]["status_description"] = "Choose whether the trigger is Active or Inactive. Inactive triggers will not be executed.";
$lang["form"]["label"]["name"] = "Trigger name";
$lang["form"]["label"]["name_description"] = "Assign a name to the trigger for easy identification.";
$lang["form"]["label"]["event_criteria"] = "Event";
$lang["form"]["event_criteria_option"]["select_criteria"] = "Select an event";
$lang["form"]["event_criteria_option"]["add_to_list"] = "Contact is added to a list";
$lang["form"]["event_criteria_option"]["add_to_segment"] = "Contact is added to a segment";
$lang["form"]["label"]["select_date"] = "Select date";
$lang["form"]["label"]["segment_ist"] = "Select a segment";
$lang["form"]["label"]["list_type"] = "List selection";
$lang["form"]["label"]["list_type_description"] = "Choose whether the event is triggered by a contact being added to a specific selected list or any list within the system.";
$lang["form"]["list_type_option"]["list_type_global"] = "Any list";
$lang["form"]["list_type_option"]["list_type_global_description"] = "The trigger will be executed when a contact is added to any of the available contact lists.";
$lang["form"]["list_type_option"]["list_type_selected"] = "Selected lists";
$lang["form"]["list_type_option"]["list_type_selected_description"] = "The trigger will be executed when a contact is added to one of the selected contact lists.";
$lang["form"]["list_type_option"]["select_lists_description"] = "Select from the list below.";
$lang["form_heading"]["action"] = "Action";
$lang["form_heading"]["action_description"] = "Decide the action.";
$lang["form"]["label"]["custom_field"] = "Custom field";
$lang["form"]["label"]["custom_field_description"] = "Suppression";
$lang["form"]["label"]["global_suppression_list"] = "Global suppression";
$lang["form"]["label"]["global_suppression_list_description"] = "List-specific suppression";
$lang["form"]["label"]["select_email_campaign"] = "Select broadcast";
$lang["form"]["label"]["select_email_campaign_description"] = "Select the broadcast to send when the event occurs.";
$lang["form"]["label"]["smpt_list"] = "Sending Node";
$lang["form"]["label"]["smpt_list_description"] = "Select the sending node that will be responsible to relay this email.";
$lang["form"]["label"]["select_date_field"] = "Select date field";
$lang["form"]["label"]["segment_type"] = "Segment selection";
$lang["form"]["segment_type_option"]["segment_type_global"] = "Any segment";
$lang["form"]["segment_type_option"]["segment_type_selected"] = "Selected segments";
$lang["form"]["label"]["campaign_type"] = "Campaign selection";
$lang["form"]["campaign_type_option"]["campaign_type_global"] = "Any campaign";
$lang["form"]["campaign_type_option"]["campaign_type_selected"] = "Selected campaigns";
$lang["form"]["label"]["link_clicked"] = "Link clicked";
$lang["form"]["label"]["when_to_execute"] = "When to execute";
$lang["form"]["label"]["when_to_execute_description"] = "<p><strong>Instantly:</strong> Performs the action immediately when the event occurs<br>
<strong>After some time:</strong> Executes the action after a specified delay or interval following the event</p>";
$lang["form"]["when_to_execute_option"]["after_the_event"] = "After some time";
$lang["form"]["when_to_execute_option"]["instantly"] = "Instantly";
$lang["form"]["label"]["to_email"] = "Email address";
$lang["form"]["label"]["subject"] = "Subject";
$lang["form"]["label"]["action_to_perform"] = "Action to perform";
$lang["form"]["action_to_perform_option"]["send_broadcast"] = "Send a broadcast";
$lang["form"]["action_to_perform_option"]["send_notification_email"] = "Send a notification email to admin";
$lang["form"]["action_to_perform_option"]["start_drip_group"] = "Start a drip group";
$lang["form"]["action_to_perform_option"]["stop_drip_group"] = "Stop a drip group";
$lang["form"]["action_to_perform_option"]["change_subscriber_status"] = "Change status to active or inactive";
$lang["form"]["action_to_perform_option"]["change_subscriber_format"] = "Change format to receive HTML or Text";
$lang["form"]["action_to_perform_option"]["change_subscriber_validation_status"] = "Change validation status";
$lang["form"]["action_to_perform_option"]["update_field_value"] = "Update a custom field value";
$lang["form"]["action_to_perform_option"]["move_subscriber"] = "Move contact to another list";
$lang["form"]["action_to_perform_option"]["copy_subscriber"] = "Copy contact to another list";
$lang["form"]["action_to_perform_option"]["remove_subscriber"] = "Delete the contact";
$lang["form"]["action_to_perform_option"]["add_to_suppresion"] = "Add contact to suppression list";
$lang["form"]["label"]["frequency"] = "Frequency";
$lang["form"]["frequency_option"]["run_once"] = "Run once";
$lang["form"]["frequency_option"]["repeat_every_month"] = "Repeat every month";
$lang["form"]["frequency_option"]["repeat_every_year"] = "Repeat every year";
$lang["edit"]["title"] = "Edit Trigger";
$lang["edit"]["description"] = "Modify the settings of an existing trigger, including its event criteria, execution timing, and associated actions. Adjust the trigger's status, update selected lists or segments, and fine-tune the delay or interval for executing actions based on your needs.";
$lang["view"]["success_message"]["save_order"] = "The running order has been updated successfully.";
$lang["view"]["success_message"]["change_status"] = "Trigger status has been changed successfully.";
$lang["view"]["error_message"]["change_status"] = "Failed to change the trigger status.";
$lang["view"]["alert_message"]["empty_field"] = "Empty field.";
$lang["update"]["notification"]["activity_title"] = "Trigger";
$lang["form"]["label"]["if_duplicates_found"] = "If duplicates found";
$lang["form"]["if_duplicates_found_option"]["skip_duplicate_keep_original"] = "Skip duplicate and keep in the original list";
$lang["form"]["if_duplicates_found_option"]["skip_duplicate_remove_original"] = "Skip duplicate and remove from the original list";
$lang["form"]["if_duplicates_found_option"]["overwrite_duplicate"] = "Overwrite duplicate (will remove from the original list)";
$lang["form"]["if_duplicates_found_option"]["skip_duplicate"] = "Skip duplicate";
$lang["form"]["if_duplicates_found_option"]["update_duplicate"] = "Update duplicate";
$lang["form"]["label"]["select_autoresponder"] = "Select a drip campaign";
$lang["form"]["sub_event_criteria_option"]["subscriber_manually_added"] = "Contact is manually added to a list";
$lang["form"]["sub_event_criteria_option"]["subscriber_imported"] = "Contact is imported to a list";
$lang["form"]["sub_event_criteria_option"]["subscriber_added_via_webform"] = "Contact is added through a web form";
$lang["form"]["sub_event_criteria_option"]["subscriber_added_via_api"] = "Contact is added through API";
$lang["form"]["sub_event_criteria_option"]["apply_all"] = "Apply all";
$lang["form"]["add_subscriber_option"]["subscriber_creation_date"] = "Contact's creation date";
$lang["form"]["alert_message"]["subscriber_birthday"] = "Contact's Birthday";
$lang["form"]["alert_message"]["on_calendar_date"] = "On a specific calendar date";
$lang["form"]["alert_message"]["campaign_opened"] = "An email has been opened";
$lang["form"]["alert_message"]["link_clicked"] = "A link has been clicked";
$lang["form"]["trigger_type"]["bounced"] = "Bounced";
$lang["form"]["trigger_type"]["bounced_code"] = "Bounce code";
$lang["form"]["trigger_type"]["custom_criteria"] = "Custom criteria";
$lang["view"]["modal_heading"]["trigger_pause_title"] = "Trigger contains a blocked contact list";
$lang["view"]["modal_heading"]["trigger_pause_title_description"] = "This trigger contains a blocked contact list, so it cannot be activated. You can edit this trigger and remove the blocked contact list to make it work.";
$lang["view"]["modal_heading"]["monthly_action_limit"] = "The monthly actions limit has been reached.";
$lang["process"]["notification"]["trigger_limit"] = "The trigger <b>:trigger_name</b> has been set inactive as your monthly limit for trigger actions has been reached.";
$lang["process"]["notification"]["list_blocked"] = "The trigger <b>:trigger_name</b> has been set inactive as it contains a blocked contact list.";
$lang["view"]["error_message"]["actions_limit"] = "The limit for the trigger actions has been exceeded. The effected triggers will be auto-activated upon limit reset.";
$lang["view"]["alert_message"]["actions_usage"] = "You have utilized :precentage% of your assigned trigger actions limit (used: :usedLimit, limit: :totalLimit).";
$lang["form"]["alert_message"]["contact_administrator_action"] = "Contact administrator!";
$lang["form"]["alert_message"]["session_limit_reached"] = "Opsss... The limit has been reached.";
$lang["schdule"]["log"]["trigger_campaign_create_error"] = "Failed to trigger the campaign.";
$lang["schdule"]["log"]["trigger_drip_create_error"] = "Failed to trigger the drip.";
$lang["form"]["recursively_label_description"]["qualified"] = "By selecting this option, the trigger will not only process newly qualified contacts but will also run recursively on all contacts in the selected lists, ensuring that past and future contacts are evaluated.";
$lang["form"]["label"]["contacts_recursively"] = "Apply to all contacts recursively";
$lang["trigger"] = "Triggers Sorting";
$lang["sorting"]["title"] = "Triggers Sorting";
$lang["success_message"]["unsubscribed_successfully_echo"] = "You have been unsubscribed successfully.";
$lang["form"]["custom_field_option"]["select_choose_option"] = "Choose an option";
$lang["form"]["trigger_type"]["options_label"] = "Options:";
$lang["form"]["custom_field_option"]["changed_any_value_span"] = "Changed to any value";
$lang["form"]["custom_field_option"]["changed_this_value_span"] = "Changed to this value";
$lang["form"]["custom_field_option"]["select_field_option"] = "Select a field";
$lang["form"]["custom_field_option"]["selected_field_span"] = "Selected field";
$lang["form"]["custom_field_option"]["any_field_span"] = "Any field";
$lang["form"]["trigger_type"]["select_field_value_change"] = "When a field value is changed";
$lang["view"]["alert_warning"]["blocked_contact_list_command"] = "This trigger contains a blocked contact list and cannot be activated.";
$lang["view"]["table_warning"]["label_note"] = "Note";
$lang["view"]["table_warning"]["set_run_ever"] = "The triggers are set to run every";
$lang["view"]["table_warning"]["minutes_text"] = "minutes.";
$lang["view"]["table_warning"]["change_this_cron_setting"] = "You can change this on the Cron Settings page.";
$lang["view"]["table_heading"]["description"] = "Description";
$lang["view"]["table_heading"]["enable_users"] = "Enable for Users";
$lang["form"]["description"] = "Description";
$lang["form"]["description_help"] = "Provide a brief description for this trigger template.";
$lang["templates"]["view"]["title"] = "Triggers Templates";
$lang["templates"]["view"]["description"] = "Create and manage reusable templates for automating actions based on specific events or conditions. These templates enable you to streamline your marketing workflows and deliver timely, personalized communications to your subscribers, enhancing engagement and efficiency.";
$lang["templates"]["add"]["title"] = "Add Trigger Template";
$lang["templates"]["edit"]["title"] = "Edit Trigger Template";
$lang["templates"]["add"]["enable_users"] = "Enable for Users";
$lang["templates"]["add"]["enable_users_desc"] = "Allow users to access and use this template.";
$lang["templates"]["add"]["enable_users_desc_only"] = "Description";
$lang["templates"]["edit"]["description"] = "Modify an existing trigger template to refine its conditions and actions, ensuring precise automation and personalized communication with your subscribers.";
$lang["templates"]["tag"]["updated"] = "Triggers template status has been updated successfully.";
$lang["templates"]["tag"]["not_found"] = "No trigger template found.";
$lang["templates"]["available_templates"] = "Templates";
$lang["templates"]["defined_templated"] = "Pre-defined templates";
$lang["templates"]["clone"] = "Clone";
$lang["templates"]["cloned"] = ":tag has been cloned successfully.";
$lang["templates"]["bulk_cloned"] = ":tag out of :count triggers cloned successfully.";
$lang["add"]["btn_select_template"] = "Select a template";
$lang["add"]["btn_close_templates"] = "Collapse templates";
$lang["add"]["btn_use_this"] = "Use this template";
$lang["add"]["btn_pre_define_template"] = "Select from the pre-defined templates";
$lang["add"]["box_title"] = "Templates";
$lang["add"]["alert_confirm_title"] = "Are you sure?";
$lang["add"]["alert_confirm_description"] = "It will override the current selection.";
$lang["templates"]["add_edit"]["save"] = "Save";
$lang["view"]["button"]["templates"] = "Templates";
$lang["add"]["exists"] = ":attribute with this name already exists.";
$lang["templates"]["exists"] = ":tag out of :count triggers cloned successfully.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
