<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["error_message"]["update_dns"] = "Update DNS Records.";
$lang["edit"]["button"]["confirm"] = "Confirm";
$lang["view"]["alert_warning"]["delete_domain"] = "<b>Error:</b> Unassign the domain (:domain) from the associated assets before deleting it.";
$lang["view"]["model_heading"]["dependency_check"] = "Dependency Check";
$lang["view"]["model_heading"]["shift_assets_another_domain"] = "Move assets to another domain";
$lang["view"]["title"] = "Sending Domains";
$lang["view"]["description"] = "Manage your sending domains to ensure email authentication and deliverability. Add, verify, and monitor domains used for sending emails, ensuring they meet necessary authentication standards such as SPF, DKIM, and DMARC for improved inbox placement and trust.";
$lang["view"]["modal_heading"]["data_moved"] = "The sending domain has been reassigned.";
$lang["view"]["table_heading"]["actions"]["view_sending_domain"] = "View sending domain";
$lang["view"]["table_heading"]["actions"]["set_ownership_verified"] = "Set ownership as verified";
$lang["view"]["table_heading"]["actions"]["verify_public_domain_key"] = "Verify domain key";
$lang["view"]["table_heading"]["actions"]["verify_redirection"] = "Verify tracking domain";
$lang["view"]["table_heading"]["actions"]["download_domain_key_pair"] = "Download domain key pair";
$lang["view"]["table_heading"]["actions"]["download_public_domain_key"] = "Download public domain key";
$lang["view"]["table"]["label"]["dkim_verified"] = "DKIM Verified";
$lang["view"]["table"]["label"]["dkim_failed"] = "DKIM Failed";
$lang["view"]["table"]["label"]["custom_tracking_off"] = "Custom tracking domain is disabled.";
$lang["view"]["table"]["link_warning"]["verification_required"] = "Verification Required";
$lang["view"]["table"]["link_danger"]["verification_failed"] = "Verification Failed";
$lang["view"]["table_heading"]["sending_domain"] = "Sending Domain";
$lang["view"]["table_heading"]["tracking_domain"] = "Tracking Domain";
$lang["view"]["table_heading"]["tracking_prefix"] = "Tracking Prefix";
$lang["view"]["table_heading"]["redirection_type"] = "Redirection Type";
$lang["view"]["table_heading"]["dkim"] = "DKIM";
$lang["view"]["table_heading"]["verified"] = "Verified";
$lang["add"]["title"] = "Add a Sending Domain";
$lang["add"]["description"] = "Add a new domain to ensure proper email authentication and deliverability. Add your domain, verify DNS records, and set up DKIM, SPF, and other authentication protocols to optimize email sending performance.";
$lang["form_heading"] = "Sending Domain Details";
$lang["form"]["label"]["sending_domain"] = "Domain Name";
$lang["form"]["label"]["sending_domain_help"] = "Insert your domain name without including \"www\" or \"http/https\" (e.g., myagency.com).";
$lang["form"]["label"]["sending_domain_description"] = "Insert the Domain name you want to send from.";
$lang["form"]["label"]["use_secure_url_description"] = "If enabled, " . $lang["variables"]["site_title"] . " will generate tracking links using the HTTPS protocol for this tracking domain.";
$lang["edit"]["title"] = "Sending Domain:";
$lang["widget_heading"]["authenticate_your_domain"] = "Sending Domain Authentication";
$lang["form"]["button"]["recheck"] = "Recheck";
$lang["form"]["button"]["recheck_msg"] = "Button is disabled until";
$lang["widget_heading"]["domain_ownership_required"] = "Domain Ownership Verification";
$lang["form"]["heading"]["domain_ownership_note"] = "Before using the sending domain, you must verify domain ownership using one of the following methods:";
$lang["form"]["label"]["upload_file"] = "Upload a File";
$lang["form"]["label"]["dns_record"] = "Add a DNS Record";
$lang["form"]["label"]["download_and_upload_file"] = "Download the file by clicking on the link below and upload it to the root folder of your domain";
$lang["form"]["upload_file_list"]["download_this_file"] = "Download the file below";
$lang["form"]["upload_file_list"]["access_publicly_url"] = "Upload it to the root folder of your domain so it gets accessible publicly at this URL";
$lang["form"]["upload_file_list"]["verify_link"] = "Verify that the link is accessible";
$lang["form"]["download_link"]["download_here"] = "Download File";
$lang["form"]["label"]["add_text_record"] = "Add the following TXT record";
$lang["view"]["table_heading"]["host"] = "Host";
$lang["view"]["table_heading"]["type"] = "Type";
$lang["view"]["table_heading"]["value"] = "Value";
$lang["form"]["button"]["verify_domain"] = "Verify Domain";
$lang["form"]["widget_heading"]["verify_domain"] = "DKIM Authentication";
$lang["form"]["label"]["enable_dkim"] = "Sign Outgoing Emails";
$lang["form"]["switch_message"]["enable_mumara"] = "If enabled, " . $lang["variables"]["site_title"] . " will sign your outgoing emails with a domain key. After enabling, ensure that the public DNS entry is added.";
$lang["form"]["label"]["generate_dkim"] = "Generate Domain Keys";
$lang["form"]["label"]["generate_dkim_description"] = "Generate the public and private domain keys needed to authenticate your sending domain with DKIM. These keys ensure your emails are securely signed, improving deliverability and email authenticity.";
$lang["form"]["heading"]["authenticate_title"] = "Secure your sending domain with DKIM authentication";
$lang["form"]["heading"]["authenticate_description_1"] = "Set up DKIM authentication to ensure your emails are securely signed and improve deliverability by verifying the authenticity of your domain";
$lang["form"]["heading"]["authenticate_description_2"] = "Access the DNS zone for your domain and add the following record.";
$lang["form"]["link"]["regenerate_dkim"] = "Regenerate Keys";
$lang["form"]["link"]["regenerate_keys"] = "Regenerate Keys";
$lang["form"]["link_popover"]["download_private_key"] = "Download Domain Keys";
$lang["form"]["widget_heading"]["custom_tracking_domain"] = "Custom Tracking Domain";
$lang["form"]["label"]["enable_custom_tracking_domain"] = "Enable Tracking Domain";
$lang["form"]["switch_message"]["enable_custom_tracking_domain_msg"] = "Configure a custom tracking domain to replace the default system domain in all tracking links and image paths within your emails.";
$lang["form"]["label"]["cname"] = "CNAME";
$lang["form"]["label"]["cname_description_1"] = "Login to the DNS zone of your domain";
$lang["form"]["label"]["cname_description_2"] = "and add the following entry.";
$lang["form"]["label"]["htaccess"] = ".htaccess";
$lang["form"]["label"]["htaccess_description_1"] = "Download the file, extract it, and upload the .htaccess file to the root folder of the tracking domain";
$lang["form"]["label"]["htaccess_description_2"] = "(This method is more suitable if you want to avoid exposing your primary domain IP in trace routes.)";
$lang["form"]["button"]["htaccess_download"] = "Download File";
$lang["form"]["widget_heading"]["dkim"] = "DKIM";
$lang["form"]["label"]["public_key"] = "Public Key";
$lang["form"]["label"]["private_key"] = "Private Key";
$lang["form"]["widget_heading"]["spf"] = "SPF";
$lang["form"]["widget_heading"]["domain_key"] = "Domain Key Identification Method";
$lang["edit"]["model"]["dkim_info"] = "DomainKeys Identified Mail (DKIM) is an email authentication method that helps detect forged sender addresses, commonly used in phishing and spam emails.";
$lang["edit"]["model"]["generate_keys"] = "Generate Keys";
$lang["form"]["label"]["setup_tracking_domain"] = "Setup Tracking Domain";
$lang["form"]["label"]["setup_tracking_domain_description"] = "This subdomain will be used for all hyperlinks, image URLs, and tracking pixels in outgoing emails.";
$lang["form"]["label"]["label_note"] = "Note:";
$lang["form"]["label"]["php_redirect_code"] = "allow_url_fopen";
$lang["form"]["label"]["php_redirect_message"] = "must be enabled in the PHP settings of your tracking domain";
$lang["update"]["notification"]["activity_title"] = "Sending Domain";
$lang["form"]["success_tooltip"]["dkim_verified"] = "DKIM Verified";
$lang["form"]["error_tooltip"]["dkim_failed"] = "DKIM Failed";
$lang["form"]["success_tooltip"]["tracking_domain_verified"] = "Tracking Domain Verified";
$lang["form"]["error_tooltip"]["tracking_domain_failed"] = "Tracking Domain Failed";
$lang["form"]["label"]["use_secure_url"] = "Use Secure URL";
$lang["form"]["label"]["domain_status"] = "Domain Status";
$lang["form"]["alert_warning"]["modal_note"] = "Primary domain needs to be propagated before you can add a sending domain";
$lang["form"]["alert_warning"]["set_primary_domain"] = "Configure Primary Domain";
$lang["form"]["label"]["lists"] = "Lists";
$lang["form"]["option_placeholder"]["select_domain"] = "Select domain";
$lang["form"]["success_message"]["keys_generates_successfully"] = "The domain keys have been generated successfully.";
$lang["form"]["success_message"]["domain_verified"] = "Domain has been verified.";
$lang["form"]["error_message"]["domain_not_verified"] = "Domain has not been verified.";
$lang["form"]["error_message"]["no_spa_found"] = "No SPF record found.";
$lang["form"]["error_message"]["domains_are_not_being_used"] = "Domains not in use with sending nodes or lists have been successfully deleted.";
$lang["form"]["success_message"]["confirm_delete"] = "<strong>:masking1_domain</strong> has been deleted successfully, and the affected assets have been reassigned to <strong>:masking2_domain</strong>.";
$lang["form"]["error_message"]["domain_already_linked"] = "Domain :domain is already linked.";
$lang["form"]["error_message"]["domain_already_exists"] = "Domain :domain already exists.";
$lang["form"]["error_message"]["maximum_domain_limit"] = "You have reached your maximum sending domains limit of :limit.";
$lang["form"]["error_message"]["not_allowed"] = "You are not allowed to add this domain.";
$lang["form"]["success_message"]["successfully_updated"] = "Updated successfully!";
$lang["modal"]["regenerate_keys_identified"]["method_description"] = "Are you sure you want to regenerate domain keys?";
$lang["form"]["alert_message"]["enter_domain_key"] = "Please enter the domain key first.";
$lang["form"]["error_message"]["confirmed_failed"] = "Confirmation failed.";
$lang["form"]["error_message"]["problem_generate_key"] = "There was a problem generating the keys!";
$lang["form"]["alert_message"]["congrats_domain_confirmed"] = "Congrats! Domain has been confirmed.";
$lang["form"]["error_message"]["technical_error"] = "A technical error occurred!";
$lang["form"]["alert_message"]["dns_alert_info"] = "If you have recently updated the DNS records, it may take a few hours for the changes to fully propagate.";
$lang["form"]["warning_message"]["tracking_domain_not_work"] = "The CNAME record has been resolved successfully, but your tracking domain may not function correctly because the DocumentRoot for :domain is not pointing to the root directory of " . $lang["variables"]["site_title"] . ". For more information, read <a href='https://school.mumara.com/training/why-your-tracking-domain-isnt-verifying/'>this article</a>.";
$lang["form"]["warning_message"]["no_valid_ssl_certificate_found"] = "No valid SSL certificate was found on :domain, so tracking links will not work. Either install an SSL certificate or disable the \"Use Secure\" option.";
$lang["form"]["error_message"]["assign_to_other"] = "You can reassign the assets to another domain.";
$lang["modal"]["table_heading"]["host"] = "Host";
$lang["modal"]["table_heading"]["value"] = "Value";
$lang["modal"]["table_heading"]["type"] = "Type";
$lang["modal"]["table_heading"]["provider"] = "Provider";
$lang["modal"]["table_heading"]["status"] = "Status";
$lang["modal"]["table_heading"]["response"] = "Response";
$lang["edit"]["label"]["small_priority"] = "priority";
$lang["edit"]["table_heading"]["current_value"] = "Current Value";
$lang["edit"]["table_heading"]["enter_value"] = "Enter This Value";
$lang["edit"]["table_heading"]["text"] = "TXT";
$lang["edit"]["table_heading"]["domain"] = "Domain";
$lang["edit"]["label_description"]["spf_record_domain"] = "Add the following SPF record to your sending domain to ensure compliance with Sender Policy Framework (SPF) authentication standards.";
$lang["edit"]["widget_heading"]["custom_bounce_domain"] = "Custom Bounce Domain";
$lang["edit"]["link"]["download_php_file"] = "Download File";
$lang["edit"]["label"]["cloak_text"] = "Cloak";
$lang["edit"]["table_heading"]["download_file"] = "File";
$lang["edit"]["label"]["download_generated_php_file"] = "Download the generated PHP file and place at the root folder of your tracking domain";
$lang["edit"]["label_warning"]["authentication_failed"] = "Authentication Failed";
$lang["edit"]["label_warning"]["pending_authentication"] = "Pending Authentication";
$lang["edit"]["label_error"]["suspended"] = "Suspended";
$lang["edit"]["label"]["mx_text"] = "MX";
$lang["edit"]["label_warning"]["pending"] = "Pending";
$lang["edit"]["label_success"]["passed"] = "Passed";
$lang["edit"]["error_message"]["select_domain_html"] = "Select a domain.";
$lang["edit"]["button"]["domain_limit"] = "Domains Limit";
$lang["notfound"]["alert_message"]["title"] = "An issue has occurred.";
$lang["notfound"]["alert_message"]["description_1"] = "We were unable to test the cloaking. Download the cloaking file and upload it to the root folder of tracking domain <code>";
$lang["notfound"]["alert_message"]["description_2"] = "</code>.";
$lang["notfound"]["alert_message"]["button"]["confirm"] = "Download File";
$lang["notfound"]["alert_success"]["title"] = "The file has been downloaded.";
$lang["notfound"]["alert_success"]["description"] = "The download has been started.";
$lang["failed"]["alert_message"]["title"] = "An issue has occurred.";
$lang["failed"]["alert_message"]["description_1"] = "The cloaking file placed at the root folder of your tracking domain <code>";
$lang["failed"]["alert_message"]["description_2"] = "</code> is old and it needs to be updated. Download the latest file again and replace with the older one.";
$lang["failed"]["button"]["confirm"] = "Download File";
$lang["failed"]["alert_success"]["title"] = "The file has been downloaded.";
$lang["failed"]["alert_success"]["description"] = "The download has been started.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
