<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Security";
$lang["view"]["description"] = "Enhance your account security by updating your password, adding trusted IP addresses to restrict access, and reviewing active sessions for any unusual activity. Enable two-factor authentication to add an extra layer of protection and secure your account from unauthorized access.";
$lang["view"]["widget_heading"]["password"] = "Password";
$lang["view"]["widget_heading"]["password_description"] = "Regularly updating your password is crucial to prevent unauthorized access to your account.";
$lang["view"]["button"]["change_password"] = "Change Password";
$lang["view"]["widget_heading"]["allow_ip_address"] = "Allowed IP Addresses";
$lang["view"]["widget_heading"]["allow_ip_address_description"] = "Restrict access by adding a range of trusted IP addresses. If no IP address is added, the account will be accessible from any IP address.";
$lang["view"]["button"]["add_ip_address"] = "Add IP Address";
$lang["view"]["modal"]["ensure_static_ip_address"] = "Ensure that the IP address you provide is a static IP address. Since the dynamic IP addresses change and you might get locked out of your account.";
$lang["view"]["modal"]["further_signins"] = "All future sign-ins will only be permitted from this IP range.";
$lang["view"]["modal"]["ip_option"]["current_ip_address"] = "Add your current IP address";
$lang["view"]["modal"]["ip_option"]["static_ip_address"] = "Add a static IP address";
$lang["view"]["modal"]["ip_option"]["add_ip_range"] = "Add an IP range";
$lang["view"]["modal"]["ip_option"]["add_subnet"] = "Add a subnet";
$lang["view"]["modal"]["label"]["your_ip_address"] = "Your IP address";
$lang["view"]["modal"]["error-message"]["invalid_subnet"] = "Invalid subnet";
$lang["view"]["modal"]["label"]["ip_name"] = "IP Label";
$lang["view"]["modal"]["error-message"]["friendly_ip_name"] = "Give this IP address a friendly name.";
$lang["view"]["widget_heading"]["active_sessions"] = "Active Sessions";
$lang["view"]["widget_heading"]["active_sessions_description"] = "View and manage all active sessions.";
$lang["view"]["widget_heading"]["two_factor_authentication"] = "Two-Factor Authentication";
$lang["view"]["widget_heading"]["two_factor_authentication_description"] = "Every time you sign in, you'll need both your password and a time-based authentication token.";
$lang["view"]["two_factor_authentication"]["title"] = "Protect your account with a two-step authentication";
$lang["view"]["two_factor_authentication"]["description"] = "Enable multi-factor authentication and secure your " . $lang["variables"]["site_title"] . " account.";
$lang["view"]["modal"]["label"]["started_time"] = "Session started on";
$lang["view"]["modal"]["label"]["backup_code"] = "Your backup code is:";
$lang["view"]["modal"]["button"]["get_started"] = "Get Started";
$lang["view"]["modal"]["alert_message"]["two_fa_description"] = "Two-factor authentication adds an extra layer of protection to your account. Once enabled, each time you sign in to " . $lang["variables"]["site_title"] . ", you’ll need to authenticate using a time-based token after successfully signing in with your credentials.";
$lang["view"]["modal"]["title"]["one_time_password"] = "<h4>Time-Based One-Time Password</h4>
<p>This authentication option uses a time-based algorithm for the second factor. Your mobile device can generate these codes. If you don't already have an app, we recommend Google Authenticator, available for iOS, Android, and Windows mobile devices.</p>
<p>To configure your authentication app:</p>
<ul class='auth-list'>
  <li>Select to add a new time-based token.</li>
  <li>Use your app to scan the QR code below, or manually enter this secret key manually:<br>
  <div id=''></div>
  </li>
</ul>";
$lang["view"]["modal"]["description"]["one_time_password"] = "Secret Key";
$lang["view"]["modal"]["label"]["ignore_spaces"] = "Spaces don't matter";
$lang["view"]["modal"]["title"]["verification_step"] = "Verify Code";
$lang["view"]["modal"]["description"]["enter_security_code"] = "Enter the security code generated by your authenticator app to ensure it's configured correctly before enabling it.";
$lang["view"]["modal"]["description"]["disable_two_fa"] = "To disable Two-Factor Authentication, please confirm your password in the field below.";
$lang["view"]["modal_heading"]["password_reset_request"] = "Reset Account Password";
$lang["view"]["modal"]["description"]["enter_email_address"] = "Enter your email address below, and we will send you instructions to reset your password.";
$lang["view"]["modal"]["alert_message"]["two_fa_enable"] = "Two-factor authentication has been successfully enabled.";
$lang["view"]["modal"]["alert_message"]["two_fa_disable"] = "Two-factor authentication has been successfully disabled.";
$lang["view"]["modal"]["alert_warning"]["invalid_code"] = "The code entered appears to be invalid. Please enter the correct code to proceed.";
$lang["view"]["modal"]["alert_message"]["session_account_removed"] = "No sessions found.";
$lang["view"]["modal"]["label"]["atleast_characters_help_text"] = "Include at least 8 characters.";
$lang["view"]["modal"]["description"]["set_strong_password"] = "Set a strong password to prevent unauthorized access to your account.";
$lang["view"]["modal"]["error_message"]["enter_a_valid_ip"] = "Enter a valid IP address.";
$lang["view"]["modal"]["error_message"]["enter_a_valid_email"] = "Enter a valid email address.";
$lang["view"]["modal"]["description"]["save_two_fa"] = "Store it to a safe document.<br>It will be required if you lose access to your second-factor device or it becomes unavailable.";
$lang["view"]["modal_heading"]["two_fa_authentication_complete"] = "Two-factor authentication setup is complete!";
$lang["view"]["modal"]["error_message"]["code_not_matched"] = "The code you entered did not match the expected one. Please try again.";
$lang["view"]["modal"]["success_message"]["verification_link_sent"] = "Email verification link has been sent successfully.";
$lang["view"]["modal"]["success_message"]["ip_terminated"] = "IP address has been terminated successfully.";
$lang["view"]["modal"]["alert_message"]["current_ip_not_listed"] = "<div class='alone_current_ip'>
  <div class='note_ip'>Note</div>
  <div class='ip_note_desc'>
    Your current IP address <b>:ip</b> is not within the allowed IP ranges below. Once you sign out, you will not be able to sign in again from this IP address. 
    <a href='#'>Click here to add your current IP address.</a>
  </div>
</div>";
$lang["view"]["modal"]["button"]["request"] = "Request";
$lang["view"]["modal"]["label"]["device_name"] = "Computer";
$lang["view"]["modal"]["label"]["device_time"] = "a few seconds ago";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
