<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Feedback Loops";
$lang["view"]["description"] = "Manage subscribers who report your emails as abuse using Feedback Loops (FBL). The mailbox provider forwards the reported message to a designated email address, allowing you to suppress or remove the complaining user from your database.";
$lang["processed"]["title"] = "Processed Feedback Loops  ";
$lang["processed"]["description"] = "Details on feedback loops that have already been processed.";
$lang["view"]["table_heading"]["email"] = "FBL Email";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["view"]["table_heading"]["last_processed"] = "Last Processed";
$lang["view"]["table_heading"]["complaints"] = "Complaints";
$lang["processed"]["table_heading"]["abuser"] = "Email Address";
$lang["processed"]["table_heading"]["contact"] = "Contact ID";
$lang["processed"]["table_heading"]["user"] = "User";
$lang["processed"]["table_heading"]["campaign"] = "Campaign/Trigger";
$lang["processed"]["table_heading"]["abused_at"] = "Complaint Time";
$lang["processed"]["table_heading"]["message_id"] = "Message ID";
$lang["processed"]["table_heading"]["sr"] = "No.";
$lang["add"]["title"] = "Add Feedback Loop";
$lang["add"]["description"] = "Link your feedback loop mailbox to allow " . $lang["variables"]["site_title"] . " to automatically process spam complaints received from email providers. This integration helps you manage and flag the recipients who report your emails as spam, maintaining the health of your email list.";
$lang["form_heading"] = "Feedback Loop Settings";
$lang["form"]["label"]["email"] = "FBL Email";
$lang["form"]["label"]["email_description"] = "The email address of the FBL mailbox.";
$lang["form"]["label"]["host"] = "Hostname";
$lang["form"]["label"]["host_description"] = "The hostname of the server hosting the FBL mailbox.";
$lang["form"]["label"]["port"] = "Port";
$lang["form"]["label"]["port_description"] = "The port number for the mailbox server.";
$lang["form"]["label"]["username"] = "Username";
$lang["form"]["label"]["username_description"] = "The username for accessing the FBL mailbox.";
$lang["form"]["label"]["password"] = "Password";
$lang["form"]["label"]["password_description"] = "The password for accessing the FBL mailbox.";
$lang["form"]["label"]["folder"] = "Folder";
$lang["form"]["label"]["folder_description"] = "The folder where incoming complaint emails are placed. Default: Inbox.";
$lang["form"]["label"]["validate_certificate"] = "Validate Certificate";
$lang["form"]["label"]["validate_certificate_description"] = "Select \"Yes\" if the server requires SSL certificate validation.";
$lang["form"]["label"]["encryption_description"] = "Select the encryption type if the connection to the remote server requires it.";
$lang["form"]["label"]["delete_emails"] = "Delete Emails after Processing";
$lang["form"]["label"]["delete_emails_description"] = "Enable this option to automatically delete complaint emails once they have been processed.";
$lang["form"]["label"]["connection_method"] = "Email Protocol";
$lang["form"]["label"]["connection_method_description"] = "Select the email protocol, such as POP or IMAP.";
$lang["edit"]["title"] = "Edit Feedback Loop";
$lang["edit"]["description"] = "Update your feedback loop settings by modifying the necessary details.";
$lang["update"]["notifications"]["activity_title"] = "Feedback Loop";
$lang["form"]["button"]["validate_connection"] = "Validate Connection";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
