<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Database Toolkit";
$lang["view"]["description"] = "The Database Toolkit module helps identify database-related issues and provides options to fix them automatically.";
$lang["view"]["error_message"]["old_version"] = "<b>Error:</b> You are using an older version of the application. Please update to the latest version before proceeding further.";
$lang["view"]["error_message"]["update_to_latest"] = "Update to the latest version at first";
$lang["view"]["button"]["update_application"] = "Update Application";
$lang["view"]["widget_heading"]["check_database"] = "Check your database for schema issues";
$lang["view"]["alert_message"]["press_button"] = "Click the button below to compare your database with the latest schema.";
$lang["view"]["error_message"]["error_encountered"] = "<b>Error:</b> An error occurred!";
$lang["view"]["error_message"]["unable_to_connect"] = "Unable to connect to the update server. Please ensure the following IP and port are unblocked in your server's firewall for outbound connections.";
$lang["view"]["label"]["checking_db"] = "Checking your Database...";
$lang["view"]["alert_success"]["db_uptodate"] = "Success! Your database is up to date!";
$lang["view"]["button"]["go_to_dashboard"] = "Go to Dashboard";
$lang["view"]["error_message"]["sql_missing_queries"] = "Some missing items were found in your database. SQL queries have been created to address these.";
$lang["view"]["label"]["copy_sql"] = "Copy SQL";
$lang["view"]["alert_message"]["process_started"] = "The process has started in the background and will be completed based on the size of your database.";
$lang["view"]["alert_message"]["operation_cancelled"] = "The operation has been canceled.";
$lang["view"]["success_message"]["sql_copied"] = "SQL copied successfully.";
$lang["view"]["success_message"]["changes_cancelled"] = "Database changes cancelled";
$lang["view"]["button"]["check_again"] = "Check Again";
$lang["view"]["button"]["check_remote_schema"] = "Check with Remote Schema";
$lang["view"]["widget_heading"]["run_migrations"] = "Run Migrations";
$lang["view"]["alert_message"]["migration_run_description"] = "Run migrations to check for missing schema elements and resolve issues.";
$lang["view"]["success_message"]["migration_run"] = "Migrations are running in the background.";
$lang["view"]["error_message"]["remote_server_heading"] = "Access denied to the remote server.";
$lang["view"]["widget_title"]["database_indexes"] = "Database Indexes";
$lang["view"]["widget_title"]["all_indexes"] = "All Indexes";
$lang["view"]["button"]["apply_all"] = "Apply all";
$lang["view"]["table_heading"]["table_name"] = "Table Name";
$lang["view"]["table_heading"]["indexes"] = "Indexes";
$lang["view"]["alert_confirm"]["apply_indexes"] = "Are you sure you want to apply all indexes.";
$lang["view"]["alert_error"]["apply_indexes"] = "Error in AJAX request: ";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
