<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["edit"]["title"] = "Application Settings";
$lang["edit"]["description"] = "Configure and customize the core settings of your application. This page allows you to manage system preferences, update general configurations, adjust security options, and tailor the application to meet your operational requirements.";
$lang["general"]["form"]["tab_title"] = "General";
$lang["general"]["form_heading"] = "General Settings";
$lang["general"]["form"]["label"]["force_secure_url"] = "Force secure URL";
$lang["general"]["form"]["label"]["force_secure_url_description"] = "Enforce HTTPS connections on all internal links within " . $lang["variables"]["site_title"] . ". Requires SSL installation.";
$lang["general"]["form"]["label"]["debug_mode"] = "Debug mode";
$lang["general"]["form"]["label"]["debug_mode_description"] = "Enable to access detailed error information for troubleshooting purposes.";
$lang["general"]["form"]["label"]["development_mode"] = "Development mode";
$lang["general"]["form"]["label"]["development_mode_description"] = "Disable internal caching by enabling development mode.";
$lang["general"]["form"]["label"]["url"] = "Application URL";
$lang["general"]["form"]["label"]["url_description"] = "Automatically set by " . $lang["variables"]["site_title"] . " during installation. No manual input needed.";
$lang["general"]["form"]["label"]["server_ip"] = "Server IP";
$lang["general"]["form"]["label"]["server_ip_description"] = "The IP address of the server where " . $lang["variables"]["site_title"] . " is installed.";
$lang["general"]["form"]["label"]["time_zone"] = "Timezone";
$lang["general"]["form"]["label"]["time_zone_description"] = "Set the default timezone for system operations.";
$lang["general"]["form"]["label"]["rocket_import_chunk_size"] = "Rocket import chunk size";
$lang["general"]["form"]["label"]["rocket_import_chunk_size_description"] = "Specify the number of records to process in each chunk to maintain system stability when using rocket import feature.";
$lang["general"]["form"]["label"]["msg_per_connection"] = "Number of messages per connection";
$lang["general"]["form"]["label"]["msg_per_connection_description"] = "Configure the batch size of emails sent per connection.";
$lang["general"]["form"]["label"]["delete_log_after"] = "Delete campaign logs after (days)";
$lang["general"]["form"]["label"]["delete_log_after_description"] = "Set the retention period for campaign logs to optimize the database.";
$lang["general"]["form"]["label"]["hourly_speed"] = "Hourly sending speed";
$lang["general"]["form"]["label"]["hourly_speed_description"] = "Set the maximum number of emails sent per hour.";
$lang["general"]["form"]["label"]["daily_sending_limit"] = "Daily sending limit";
$lang["general"]["form"]["label"]["daily_sending_limit_description"] = "Set the maximum number of emails sent per day.";
$lang["general"]["form"]["label"]["monthly_sending_limit"] = "Monthly sending limit";
$lang["general"]["form"]["label"]["monthly_sending_limit_description"] = "Set the maximum number of emails sent per month.";
$lang["general"]["form"]["label"]["help_article_button"] = "Disable help article buttons";
$lang["general"]["form"]["label"]["help_article_button_description"] = "Option to disable the Help Article buttons.";
$lang["contacts"]["form"]["label"]["rocket_import_default_mode"] = "Contacts import default mode";
$lang["general"]["form"]["label"]["user_can_select_file_from_server"] = "Allow users to select files from the server for importing";
$lang["general"]["form"]["label"]["user_can_select_file_from_server_description"] = "Enable this option to allow users to upload files to the server via FTP or File Manager and select from the list of previously uploaded files.
";
$lang["general"]["form"]["label"]["auto_refresh_live_events"] = "Live events auto-refresh interval";
$lang["general"]["form"]["label"]["auto_refresh_live_events_description"] = "Set the delay (in seconds) between requests for live event data.";
$lang["general"]["form"]["label"]["allow_user_import_contacts_confirmed"] = "Disable users from importing contacts with confirmed status";
$lang["general"]["form"]["label"]["allow_user_import_contacts_confirmed_description"] = "Restrict users from importing contacts as confirmed to ensure that recipients explicitly confirm their email addresses. This helps prevent users from sending spam or unsolicited emails to unconfirmed contacts, maintaining compliance with email best practices and improving deliverability.";
$lang["general"]["form"]["label"]["allow_seding_node_email_unconfirmed_contacts"] = "Disable sending emails to unconfirmed contacts";
$lang["general"]["form"]["label"]["allow_seding_node_email_unconfirmed_contacts_description"] = "Prevent emails from being sent to unconfirmed contacts, ensuring that only recipients who have actively confirmed their subscription receive your communications. This reduces the risk of spam complaints, protects your sender's reputation, and ensures compliance with email regulations. Enforcing this restriction helps maintain high deliverability rates and builds trust with your audience.";
$lang["application"]["general"]["form"]["sending_node_module"] = "Sending node module";
$lang["general"]["form"]["label"]["enable_hooks_error_logging"] = "Enable hooks error logging";
$lang["general"]["form"]["label"]["enable_hooks_error_logging_description"] = "Manage hooks error logging and enable or disable as needed.";
$lang["general"]["form"]["label"]["return_all_vars_in_hooks"] = "Return all variables in hooks";
$lang["general"]["form"]["label"]["return_all_vars_in_hooks_description"] = "Enable this option to return all variables provided by hooks during execution.";
$lang["general"]["alert_warning"]["hooks_vars_disclaimer"] = "Be cautious when using this feature, as it may affect application performance, especially in high-traffic environments.";
$lang["general"]["alert_warning"]["cronjob_disclaimer"] = "Queues will be processed automatically with the cron job.";
$lang["general"]["alert_warning"]["realtime_disclaimer"] = "The queues will be processed immediately when a hook event is triggered.";
$lang["general"]["alert_warning"]["supervisor_disclaimer"] = "A supervisor must be set up to manage the queues.";
$lang["general"]["form"]["label"]["when_to_execute_queues"] = "How to process queues?";
$lang["general"]["form"]["queues_option"]["cronjob"] = "Cronjob";
$lang["general"]["form"]["queues_option"]["realtime"] = "Realtime";
$lang["general"]["form"]["queues_option"]["supervisor"] = "Supervisor";
$lang["general"]["form"]["label"]["queue_driver"] = "Queue driver";
$lang["general"]["form"]["label"]["queue_driver_description"] = "<b>Database:</b> This method stores and processes Laravel queues using the database, allowing jobs to be queued and managed efficiently.

<b>Sync:</b> The `sync` driver processes jobs immediately, without adding them to a queue. While useful for development or testing, it’s not recommended for production because it lacks the performance benefits of a proper queue system. In production, using a dedicated queue driver is better for handling jobs asynchronously and improving overall application performance.";
$lang["general"]["form"]["queue_driver_option"]["queue_driver_database"] = "Database";
$lang["general"]["form"]["queue_driver_option"]["queue_driver_sync"] = "Sync";
$lang["general"]["form"]["label"]["count_limits_description"] = "<p>Select when you want the contacts count to update after deletions. You can choose from the following options:</p>

<ul>
  <li><strong>Realtime:</strong> The contacts count will update immediately after a contact is deleted, reflecting the changes instantly.</li>
  <li><strong>Monthly:</strong> The contacts count will update once a month, refreshing the count on a monthly basis.</li>
  <li><strong>Never:</strong> The contacts count will not update automatically after deletions, and will need to be manually refreshed.</li>
</ul>";
$lang["broadcast"]["form"]["label"]["disable_selection_sender_id_description"] = "It disables the option to automatically select the sender informaiton from sending node when sending a broadcast preview.";
$lang["broadcast"]["form"]["label"]["broadcast_unsubscribe_link_description"] = "Enable this option to have the \"Insert unsubscribe link\" switch turned on by default in the campaign scheduling wizard. Users will still have the option to toggle it off or on, but this setting ensures the unsubscribe link is pre-selected for convenience and compliance.";
$lang["general"]["form"]["label"]["gravatar"] = "Gravatar integration";
$lang["general"]["form"]["label"]["allow_user_branding"] = "Enable user branding option";
$lang["general"]["form"]["label"]["gravatar_description"] = "Gravatar integration allows users to display their globally recognized avatars based on their email addresses. When enabled, profile images are automatically pulled from Gravatar’s service and displayed within the application, giving users a personalized experience without the need to upload separate images.";
$lang["performance"]["form"]["opened_toggle_name_option"]["default"] = "Default";
$lang["performance"]["form"]["opened_toggle_name_option"]["custom"] = "Custom";
$lang["performance"]["form"]["label"]["days"] = "Days";
$lang["general"]["alert_success"]["gravatar_allowed"] = "Gravatar integration has been successfully enabled. Profile images will now be automatically displayed based on users' Gravatar settings.";
$lang["general"]["alert_warning"]["gravatar_not_allowed"] = "Gravatar integration is not available in your country.";
$lang["general"]["form"]["label"]["ctr_formula"] = "CTR Formula";
$lang["general"]["form"]["ctr_formula_option"]["clicked_opened"] = "Clicked/Opened";
$lang["general"]["form"]["ctr_formula_option"]["clicked_sent"] = "Clicked/Sent";
$lang["general"]["form"]["ctr_formula_option"]["clicked_delivered"] = "Clicked/Delivered";
$lang["mail"]["form"]["label"]["enable_from_email"] = "Embed sender email in the tracking links";
$lang["mail"]["form"]["label"]["enable_subject_email"] = "Embed subject in the tracking links";
$lang["mail"]["form"]["label"]["enable_to_email"] = "Embed recipient email in the tracking links";
$lang["general"]["form"]["label"]["application_title"] = "Application Title";
$lang["general"]["form"]["label"]["application_title_description"] = "The Application Title is the name displayed across the platform, including in the browser tab, notifications, and email headers. Customize it to reflect your brand or organization's identity.";
$lang["general"]["form"]["mini_heading"]["miscellaneous"] = "Miscellaneous";
$lang["general"]["form"]["mini_heading"]["hooks"] = "Hooks Settings";
$lang["contacts"]["form"]["label"]["limit_domain_suppressed_support"] = "Limit domain suppression count for users";
$lang["contacts"]["form"]["label"]["limit_domain_suppressed_support_description"] = "Set a limit on the number of domains users can add to their suppression list. This helps manage system resources and prevent excessive domain suppression, ensuring better control over the email sending process.";
$lang["mail"]["form"]["tab_title"] = "Mail";
$lang["mail"]["form_heading"] = "Mail Settings";
$lang["mail"]["form"]["label"]["mail_type"] = "Mail Driver";
$lang["mail"]["form"]["mail_type_option"]["mail_function"] = "PHP Mail Function";
$lang["mail"]["form"]["mail_type_option"]["smtp"] = "SMTP";
$lang["mail"]["form"]["label"]["mail_type_description"] = "Choose a mail driver to handle system-generated emails sent to administrators and users. This driver will be responsible for sending notifications, alerts, and other automated emails from the application.";
$lang["mail"]["form"]["label"]["host_description"] = "The server address used to send outgoing emails.";
$lang["mail"]["form"]["label"]["username_description"] = "The username required to authenticate with the SMTP server.";
$lang["mail"]["form"]["label"]["password_description"] = "The password needed for SMTP server authentication.";
$lang["mail"]["form"]["label"]["port_description"] = "The port number used to connect to the SMTP server.";
$lang["mail"]["form"]["label"]["encryption_description"] = "The security protocol (e.g., TLS or SSL) to protect email transmission.";
$lang["mail"]["form"]["label"]["mail_encoding_description"] = "The format used for encoding email content before sending.";
$lang["mail"]["form"]["label"]["sender_name"] = "Sender Name";
$lang["mail"]["form"]["label"]["sender_name_description"] = "The name that will appear as the sender in the recipient's inbox.";
$lang["mail"]["form"]["label"]["sender_email"] = "Sender Email";
$lang["mail"]["form"]["label"]["sender_email_description"] = "The email address that will appear as the sender in the recipient's email.";
$lang["mail"]["form"]["label"]["bcc_email"] = "BCC Email";
$lang["mail"]["form"]["label"]["bcc_email_description"] = "Email address to which a blind carbon copy of the email will be sent without the recipients knowing.";
$lang["mail"]["form"]["label"]["global_header_footer"] = "Add Global Header/Footer";
$lang["mail"]["alert_message"]["global_header_footer_alert"] = "The header and footer defined below will be added to every outgoing email.";
$lang["mail"]["form"]["label"]["global_header_description"] = "Automatically insert a predefined header or footer into all outgoing emails, ensuring consistent branding and messaging across your campaigns.";
$lang["mail"]["form"]["label"]["email_global_header"] = "Email header (HTML supported)";
$lang["mail"]["form"]["label"]["email_global_header_description"] = "The content that will be placed at the top of every outgoing email. You can include HTML for styling and customization.";
$lang["mail"]["form"]["label"]["email_global_footer"] = "Email header (HTML footer)";
$lang["mail"]["form"]["label"]["email_global_footer_description"] = "The content that will be placed at the bottom of every outgoing email. HTML can be used for formatting and adding links or branding elements.";
$lang["mail"]["form"]["label"]["force_unsubscribe_link"] = "Force unsubscribe link";
$lang["mail"]["form"]["label"]["force_unsubscribe_link_description"] = "Ensure that an unsubscribe link is included in every outgoing email, regardless of user settings. This helps maintain compliance with email regulations and provides recipients with an easy option to opt out.";
$lang["mail"]["form"]["label"]["send_systematic_email_to_admin"] = "Send system-generated emails to super admins";
$lang["mail"]["form"]["label"]["send_systematic_email_to_admin_description"] = "Automatically send system-generated emails, such as updates or important notifications, to super admins. This ensures that key administrators are informed of critical system events, such as software updates or alerts.";
$lang["sending_domain"]["form"]["tab_title"] = "Domains";
$lang["sending_domain"]["form_heading"] = "Sending Domain Settings";
$lang["sending_domain"]["form"]["label"]["default_dkim_selector"] = "Default selector for DKIM";
$lang["sending_domain"]["form"]["label"]["default_dkim_selector_description"] = "The default selector (prefix) used to identify the DKIM key for signing outgoing emails, ensuring email authentication.";
$lang["sending_domain"]["form"]["label"]["default_tracking_domain_selector"] = "Default prefix for tracking domain";
$lang["sending_domain"]["form"]["label"]["default_tracking_domain_selector_description"] = "The default subdomain or prefix used for tracking domains.";
$lang["sending_domain"]["form"]["label"]["domain_key_size_in_bits"] = "Domain key size in bits";
$lang["sending_domain"]["form"]["label"]["domain_key_size_in_bits_description"] = "The length of the DKIM key in bits used for signing outgoing emails. A larger key size provides stronger encryption and better security.";
$lang["sending_domain"]["form"]["label"]["allow_duplicate_sending_domains"] = "Allow users to add duplicate sending domains";
$lang["sending_domain"]["form"]["label"]["allow_duplicate_sending_domains_description"] = "Enable or disable the option for users to add sending domains that have already been added to the system. This helps prevent the duplication of domains across multiple users.";
$lang["sending_domain"]["form"]["label"]["require_domain_ownership_verification"] = "Require domain ownership verification";
$lang["sending_domain"]["form"]["label"]["require_domain_ownership_verification_description"] = "Ensure that users verify ownership of a sending domain before it can be used. This option is usable to prevent unauthorized use of domains and maintain email security and compliance.";
$lang["sending_domain"]["form"]["label"]["confirmation"] = "Set existing sending domains";
$lang["sending_domain"]["form"]["label"]["confirmation_option"]["set_existing_sending_domains_as_unverified"] = "<b>Requires Verification: </b>Set existing sending domains as unverified.";
$lang["sending_domain"]["form"]["label"]["confirmation_description"]["all_domains_ownership"] = "Are you sure you want to require ownership verification for all sending domains?";
$lang["sending_domain"]["form"]["error_message"]["all_domains_ownership"] = "<b>Note: </b>This will reset the verification status of all sending domains to unverified. Users will need to verify ownership before they can use the domains again.";
$lang["sending_domain"]["form"]["label"]["enable_recheck_button_title"] = "Disable DNS recheck button for (minutes)";
$lang["sending_domain"]["form"]["label"]["enable_recheck_button_title_description"] = "Set the time interval for disabling DNS recheck requests to reduce frequent DNS queries and improve performance by utilizing DNS caching within the system.";
$lang["sending_domain"]["form"]["label"]["bounce_domain_for_mx"] = "Return-path domain";
$lang["sending_domain"]["form"]["label"]["spf_include_domain"] = "SPF domain";
$lang["sending_domain"]["form"]["label"]["spf_include_prefix"] = "Subdomain prefix for custom return-path";
$lang["sending_domain"]["form"]["label"]["domain_dns_confirm"] = "DNS lookup method used to confirm and recheck the records";
$lang["sending_domain"]["form"]["label"]["domain_dns_confirm_description"] = "Choose between different DNS checking methods to prevent caching issues and ensure accurate DNS verification. This method is used when confirm or recheck button is pressed.";
$lang["sending_domain"]["form"]["label"]["domain_dns_current"] = "DNS lookup method used to fetch the current values";
$lang["sending_domain"]["form"]["label"]["domain_dns_current_description"] = "Choose between different DNS checking methods to prevent caching issues and ensure accurate DNS verification. This method is used to fetch the current values upon page load.";
$lang["sending_domain"]["form"]["domain_dns_option"]["mumara_internal"] = "Dig";
$lang["sending_domain"]["form"]["domain_dns_option"]["google_dns"] = "Google Toolbox";
$lang["sending_domain"]["form"]["domain_dns_option"]["mumara_lookup_1"] = "Mumara API Method 1";
$lang["sending_domain"]["form"]["domain_dns_option"]["mumara_lookup_2"] = "Mumara API Method 2";
$lang["sending_domain"]["form"]["label"]["mumara_dns_checkup_key"] = "API Key";
$lang["sending_domain"]["form"]["label"]["mumara_dns_checkup_key_description"] = "Enter the API key for the Mumara lookup method. If you don't have an API key, please contact support for assistance.";
$lang["broadcast"]["form"]["tab_title"] = "Campaigns";
$lang["broadcast"]["form"]["restart_stuck_option"]["yes"] = "Yes";
$lang["broadcast"]["form"]["restart_stuck_option"]["no"] = "No";
$lang["broadcast"]["form"]["restart_stuck_help_text"]["hour"] = "Hours";
$lang["broadcast"]["form"]["label"]["restart_campaigns_found_stuck"] = "Restart stuck campaigns after";
$lang["broadcast"]["form"]["label"]["restart_campaigns_found_stuck_description"] = "Set the time interval after which stuck campaigns will automatically restart. This ensures that campaigns that encounter issues or delays are restarted without manual intervention, maintaining the flow of email delivery.";
$lang["contacts"]["form"]["tab_title"] = "Contacts";
$lang["broadcast"]["form_heading"] = "Campaign Settings";
$lang["application"]["broadcast"]["form"]["allow_verify_domain"] = "Allow users to send from an email address which doesn't belong to a verified sending domain.";
$lang["broadcast"]["form"]["label"]["auto_resume"] = "Automatically resume auto-paused campaigns";
$lang["broadcast"]["form"]["label"]["auto_resume_description"] = "Enable this option to automatically resume campaigns that were paused due to sending node failures. Once the connection is reestablished, the campaigns will continue without requiring manual intervention.";
$lang["broadcast"]["form"]["label"]["double_optin_newsletter"] = "Enable unsubscribe confirmation prompt";
$lang["broadcast"]["form"]["label"]["double_optin_newsletter_description"] = "Activate this option to require users to confirm their decision before unsubscribing from your mailing list. This adds an extra step to ensure subscribers don't unintentionally remove themselves, providing more control over the unsubscription process.";
$lang["broadcast"]["form"]["label"]["disable_selection_sender_id"] = "Disable sender information selection from sending node when sending a broadcast preview";
$lang["broadcast"]["form"]["label"]["intellectual_pattern"] = "Use smart selection for tracking domain";
$lang["broadcast"]["form"]["label"]["intellectual_pattern_description"] = "Enable this option to automatically use your primary domain as a fallback if any issues arise with the assigned tracking domain. This ensures uninterrupted tracking and email link functionality.";
$lang["broadcast"]["form"]["label"]["auto_inactive_minutes"] = "Recheck auto-disabled sending node connection interval";
$lang["broadcast"]["form"]["label"]["auto_inactive_minutes_description"] = "Set the interval for automatically verifying the connection status of auto-disabled sending nodes. This process ensures that inactive nodes are regularly checked and can be reactivated if the connection is restored.";
$lang["broadcast"]["form"]["label"]["auto_inactive_hours"] = "Recheck auto-disabled sending node connection duration";
$lang["broadcast"]["form"]["label"]["auto_inactive_hours_description"] = "Set the duration for how long the system will continue to periodically recheck the connection status of auto-disabled sending nodes. Once this time period has passed, no further automatic attempts will be made to reconnect the nodes.";
$lang["broadcast"]["form"]["label"]["duplicate_open_after"] = "Ignore duplicate opens for";
$lang["broadcast"]["form"]["label"]["duplicate_open_after_description"] = "Set the time interval during which the system will ignore duplicate email opens. This prevents multiple opens within a short timeframe from being counted more than once.";
$lang["broadcast"]["form"]["label"]["list_unsub_email_title"] = "Default List-Unsubscribe email";
$lang["broadcast"]["form"]["label"]["list_unsub_email_title_description"] = "This will pre-fill the List-Unsubscribe header field when scheduling campaigns, providing recipients with an option to easily opt-out through their email client. Supported by major email providers like Gmail and Outlook.";
$lang["broadcast"]["form"]["label"]["smtp_driver"] = "SMTP driver";
$lang["broadcast"]["form"]["label"]["smtp_driver_description"] = "Select the SMTP module used for sending emails, such as PHPMailer, SwiftMailer, or Symfony Mailer, based on your server configuration and preferences.";
$lang["broadcast"]["form"]["smtp_driver_option"]["SwiftMailer"] = "Swift Mailer";
$lang["broadcast"]["form"]["smtp_driver_option"]["symfony"] = "Symfony Mailer";
$lang["broadcast"]["form"]["label"]["bounce_not_older_then_title"] = "Limit bounce email retrieval";
$lang["broadcast"]["form"]["label"]["bounce_not_older_then_title_description"] = "To improve system performance, configure " . $lang["variables"]["site_title"] . " to only retrieve bounced emails from the past few days. Since the bounce cron runs continuously, there's no need to repeatedly scan older emails in the bounce mailbox.";
$lang["performance"]["form"]["label"]["esp_callback_method"] = "ESP callback processing method";
$lang["performance"]["form"]["esp_callback_method_option"]["realtime"] = "Realtime";
$lang["performance"]["form"]["esp_callback_method_option"]["cron_based"] = "Cron";
$lang["broadcast"]["form"]["label"]["broadcast_unsubscribe_link"] = "Turn on \"Insert unsubscribe link\" option by default when scheduling campaigns";
$lang["broadcast"]["form"]["label"]["sender_info"] = "Default sender information selection";
$lang["broadcast"]["form"]["label"]["sender_info_description"] = "Choose which sender information option should be selected by default when scheduling a campaign. You can set it to automatically pull from sending node settings, list details, or use custom information.";
$lang["broadcast"]["form"]["label"]["broadcast_filter_dashboard"] = "Enable broadcast filter on the dashboard for sending overview";
$lang["broadcast"]["form"]["label"]["broadcast_filter_dashboard_description"] = "This feature activates the broadcast filter on the dashboard, allowing you to select specific broadcasts and view their corresponding statistical charts. It provides an easy way to monitor the performance of chosen broadcasts directly from the dashboard.";
$lang["broadcast"]["form"]["label"]["broadcast_restart_stuck"] = "Restart stuck campaigns";
$lang["broadcast"]["form"]["label"]["broadcast_restart_stuck_desc"] = "This feature automatically restarts campaigns that may have paused or encountered issues during execution, ensuring a smooth continuation without manual intervention.";
$lang["application"]["segment"]["title"] = "Segments";
$lang["application"]["segment"]["form"]["heading"] = "Segment Settings";
$lang["general"]["form"]["label"]["chunk_size"] = "Chunk size";
$lang["general"]["form"]["label"]["chunk_size_description"] = "Specify the number of records to be processed in each chunk to ensure system stability during database operations.";
$lang["general"]["form"]["label"]["sleep_chunks"] = "Delay between chunks";
$lang["general"]["form"]["label"]["suppression_processing_chunk_size"] = "Suppression processing chunk size";
$lang["general"]["form"]["label"]["suppression_processing_chunk_size_description"] = "Indicate the number of suppression records to be processed per chunk, ensuring efficient handling of suppression emails.";
$lang["general"]["form"]["label"]["sleep_chunks_description"] = "Set a delay time between processing chunks to manage system load and maintain performance.";
$lang["general"]["form"]["label"]["delete_export_segment"] = "Delete exported segments after";
$lang["general"]["form"]["label"]["delete_export_segment_description"] = "Specify the number of days after which exported segment files will be automatically deleted from the server.";
$lang["trigger"]["form"]["tab_title"] = "Triggers";
$lang["trigger"]["form_heading"] = "Trigger Settings";
$lang["trigger"]["form"]["label"]["triggers_cronjob_title"] = "Cronjob execution limit";
$lang["trigger"]["form"]["label"]["triggers_cronjob_title_description"] = "Define the maximum number of executions per cron job. The default is set to -1 for unlimited executions.";
$lang["trigger"]["form"]["label"]["triggers_execution_title"] = "Records per execution";
$lang["trigger"]["form"]["label"]["triggers_execution_title_description"] = "Set the number of records to process in each execution. The default is 20 to ensure optimal server performance.";
$lang["log"]["form"]["tab_title"] = "Logs";
$lang["log"]["form_heading"] = "Log Settings";
$lang["log"]["form"]["label"]["reporting_level"] = "Reporting level";
$lang["log"]["form"]["label"]["reporting_level_description"] = "Select the reporting level that fits your needs. Whether you need a brief overview or detailed reports, choose the level that helps you gather the right insights for your application.";
$lang["broadcast"]["form"]["label"]["open_unopen_chart"] = "Opened vs. unopened chart type on statistics pages";
$lang["broadcast"]["form"]["label"]["open_unopen_chart_description"] = "Switch between chart types, either bar or pie, to display data on the statistics summary page.";
$lang["broadcast"]["form"]["open_unopen_chart_option"]["horizontal_bar_graph"] = "Bar chart";
$lang["broadcast"]["form"]["open_unopen_chart_option"]["pie_chart"] = "Pie chart";
$lang["log"]["form"]["reporting_level_option"]["debug"] = "Debug";
$lang["log"]["form"]["reporting_level_option"]["error"] = "Error";
$lang["log"]["form"]["reporting_level_option"]["critical"] = "Critical";
$lang["log"]["form"]["reporting_level_option"]["info"] = "Info";
$lang["log"]["form"]["reporting_level_option"]["notice"] = "Notice";
$lang["log"]["form"]["reporting_level_option"]["warning"] = "Warning";
$lang["log"]["form"]["reporting_level_option"]["alert"] = "Alert";
$lang["log"]["form"]["label"]["logs_callbacks_title"] = "Log ESP callbacks to files";
$lang["log"]["form"]["label"]["logs_callbacks_title_description"] = "It logs ESP callbacks by saving them to files for tracking and analysis.";
$lang["log"]["form"]["label"]["no_of_files"] = "Number of files to keep";
$lang["log"]["form"]["label"]["no_of_files_description"] = "Specify the number of files for each ESP node to keep.";
$lang["performance"]["form"]["label"]["delete_subscriber"] = "Delete scheduled campaigns after";
$lang["performance"]["form"]["label"]["delete_subscriber_description"] = "Enable this option to automatically delete scheduled campaigns after a specified number of days. If enabled, related statistics will also be deleted.";
$lang["performance"]["form"]["label"]["delete_emailopenlogs"] = "Delete email open data";
$lang["performance"]["form"]["label"]["delete_emailopenlogs_description"] = "Removes all records of email opens from the database after a specified number of days.";
$lang["performance"]["form"]["label"]["delete_emailclicks"] = "Delete link click data";
$lang["performance"]["form"]["label"]["delete_emailclicks_description"] = "Removes all records of link clicks from the database after a specified number of days.";
$lang["performance"]["form"]["label"]["delete_emailbounced"] = "Delete email bounce data";
$lang["performance"]["form"]["label"]["delete_emailbounced_description"] = "Removes all records of bounced emails from the database after a specified number of days.";
$lang["performance"]["form"]["label"]["delete_unsubscribed"] = "Delete unsubscribe data";
$lang["performance"]["form"]["label"]["delete_unsubscribed_description"] = "Removes all records of email unsubscribes from the database after a specified number of days.";
$lang["log"]["form"]["label"]["delete_user_logs"] = "Delete user notification logs";
$lang["log"]["form"]["label"]["delete_user_logs_description"] = "This feature allows you to automatically delete user notification logs after a specified number of days.";
$lang["security"]["form"]["tab_title"] = "Security";
$lang["security"]["form_heading"] = "Security Settings";
$lang["security"]["form"]["label"]["security_logout_title"] = "Automatically logout idle users";
$lang["security"]["form"]["label"]["security_logout_title_description"] = "Set a timer to automatically log out users after a period of inactivity.";
$lang["security"]["form"]["label"]["remember_me"] = "Display <b>Remember Me</b> option";
$lang["security"]["form"]["label"]["remember_me_description"] = "Choose to enable or disable the 'Remember Me' option during the login process.";
$lang["security"]["form"]["label"]["session_storage"] = "Active sessions storage driver";
$lang["security"]["form"]["label"]["session_storage_description"] = "Select where to store active session files, either in the storage folder or in the database.";
$lang["integrations"]["form"]["tab_title"] = "Integrations";
$lang["integrations"]["form_heading"] = "Integration Settings";
$lang["integrations"]["form"]["label"]["google_analytics"] = "Google Analytics";
$lang["integrations"]["form"]["label"]["google_analytics_code"] = "Measurement ID";
$lang["integrations"]["form"]["label"]["google_analytics_description"] = "Enhance tracking of traffic and user behavior on " . $lang["variables"]["site_title"] . " by integrating Google Analytics.";
$lang["integrations"]["form"]["label"]["google_recaptcha"] = "Google reCAPTCHA";
$lang["integrations"]["form"]["label"]["google_recaptcha_description"] = "Protect the login form from spam and abuse by enabling Google reCAPTCHA.";
$lang["integrations"]["form"]["label"]["version"] = "Version";
$lang["application"]["api_keys"]["form"]["select_version"] = "Select version";
$lang["integrations"]["form"]["label"]["site_key"] = "Site key";
$lang["integrations"]["form"]["label"]["secret_key"] = "Secret key";
$lang["integrations"]["form"]["google_recaptcha_option"]["invisible"] = "invisible";
$lang["performance"]["form"]["tab_title"] = "Performance";
$lang["performance"]["form_heading"] = "Processing";
$lang["performance"]["form"]["mini_heading"] = "Retention";
$lang["performance"]["form"]["label"]["clicked_toggle_name"] = "Location where click files will be saved";
$lang["performance"]["form"]["label"]["opened_toggle_name"] = "Location where open files will be saved";
$lang["performance"]["form"]["label"]["clicked_toggle_name_description"] = "Track opens in real time, or schedule periodic processing with a cron job.";
$lang["performance"]["form"]["label"]["opened_toggle_name_description"] = "Track clicks in real time, or schedule periodic processing with a cron job.";
$lang["performance"]["form"]["label"]["esp_callback_method_description"] = "You can choose to track ESP callbacks in real-time or through a periodic cron job. While real-time processing provides instant feedback on bounces and complaints, it can place a heavy load on your server, especially during high email volumes. For better performance and to avoid overloading the server, it’s recommended to use cron-based callback tracking at regular intervals.";
$lang["performance"]["form"]["label"]["click_tracking"] = "Click Tracking";
$lang["performance"]["form"]["label"]["open_tracking"] = "Open Tracking";
$lang["form"]["label"]["track_processing"] = "Tracking Processing";
$lang["performance"]["form"]["tracking_option"]["realtime"] = "Real-time";
$lang["performance"]["form"]["tracking_option"]["cron"] = "Cron";
$lang["notifications"]["form"]["tab_title"] = "Notifications";
$lang["notifications"]["form_heading"] = "Notification Settings";
$lang["notifications"]["form"]["label"]["vclist"] = "Contact list has been imported";
$lang["notifications"]["form"]["label"]["list_exported"] = "Contst List has been exported";
$lang["notifications"]["form"]["label"]["segment_exported"] = "Segment has been exported";
$lang["notifications"]["form"]["label"]["segment_created"] = "Segment has been created";
$lang["notifications"]["form"]["label"]["broadcast_scheduled"] = "Campaign has been scheduled";
$lang["notifications"]["form"]["label"]["broadcast_started"] = "Scheduled campaign has been started";
$lang["notifications"]["form"]["label"]["vclist_description"] = "Enable or disable the notifications of contact list import.";
$lang["notifications"]["form"]["label"]["list_exported_description"] = "Enable or disable the notifications of contact list export.";
$lang["notifications"]["form"]["label"]["segment_exported_description"] = "Enable or disable the notifications of segment export.";
$lang["notifications"]["form"]["label"]["segment_created_description"] = "Enable or disable the notifications of segment creation.";
$lang["notifications"]["form"]["label"]["broadcast_scheduled_description"] = "Enable or disable the notifications of campaign has been scheduled.";
$lang["notifications"]["form"]["label"]["broadcast_started_help_description"] = "Enable or disable the notifications of campaign has been started.";
$lang["notifications"]["form"]["label"]["broadcast_finished_description"] = "Enable or disable the notifications of campaign has been finished.";
$lang["notifications"]["form"]["label"]["broadcast_autopaused_monthly_limit_description"] = "Enable or disable the notifications of campaign auto-paused due to monthly limit.";
$lang["notifications"]["form"]["label"]["broadcast_autopaused_daily_limit_description"] = "Enable or disable the notifications of campaign auto-paused due to daily limit.";
$lang["notifications"]["form"]["label"]["broadcast_systempaused_node_description"] = "Enable or disable the notifications of campaign auto-paused due to sending node failure.";
$lang["notifications"]["form"]["label"]["trigger_notifications_description"] = "Enable or disable the notifications of trigger auto-disabling.";
$lang["notifications"]["form"]["label"]["broadcast_finished"] = "Campaign has been finished";
$lang["notifications"]["form"]["label"]["broadcast_autopaused_monthly_limit"] = "Campaign auto-paused due to the monthly limit reached";
$lang["notifications"]["form"]["label"]["broadcast_autopaused_daily_limit"] = "Campaign auto-paused due to the daily limit reached";
$lang["notifications"]["form"]["label"]["broadcast_systempaused_node"] = "Campaign system-paused due to the sending node failure";
$lang["application"]["notifications"]["form"]["sending_node_failed"] = "Sending node has failed.";
$lang["application"]["notifications"]["form"]["trigger_action_status"] = "Triggers action status";
$lang["notifications"]["form"]["label"]["trigger_notifications"] = "Trigger has been auto-disabled";
$lang["notifications"]["form"]["label"]["heading_description"] = "You can manage the visibility of notifications to users by enabling or disabling the switches provided below.";
$lang["contacts"]["form"]["recount_upon_deletion_option"]["realtime"] = "Real-time";
$lang["contacts"]["form"]["recount_upon_deletion_option"]["monthly"] = "Monthly";
$lang["contacts"]["form"]["recount_upon_deletion_option"]["never"] = "Never";
$lang["contacts"]["form"]["label"]["recount_upon_deletion"] = "Update contacts counter upon deletion";
$lang["mail"]["form"]["label"]["enable_unsub_form_title"] = "Enable unsubscribe form";
$lang["mail"]["form"]["label"]["enable_unsub_form_title_description"] = "This feature makes an unsubscribe form available online, allowing subscriber to enter their email address and opt-out of your mailing list. Unsubscribe form can be found here :domain_name";
$lang["sending_domain"]["form"]["label"]["fallback_dkim_selector"] = "Fallback DKIM selector";
$lang["sending_domain"]["form"]["label"]["fallback_dkim_domain"] = "Fallback DKIM domain";
$lang["sending_domain"]["form"]["label"]["key_size_bits"] = "Key Size in bits";
$lang["sending_domain"]["form"]["label"]["public_key"] = "Public key";
$lang["sending_domain"]["form"]["label"]["private_key"] = "Private key";
$lang["form"]["dropdown_option"]["min"] = "Min";
$lang["form"]["dropdown_option"]["hour"] = "Hour";
$lang["mail"]["form"]["label"]["embed_id_tracking"] = "Embed Message ID in tracking links";
$lang["mail"]["form"]["label"]["embed_id_tracking_description"] = "Adds the Message ID to tracking links for enhanced tracking and identification purposes.";
$lang["mail"]["form"]["label"]["embed_utc_tracking"] = "Embed UTC timestamp in tracking links";
$lang["mail"]["form"]["label"]["embed_utc_tracking_description"] = "Adds the UTC timestamp to tracking links to improve tracking and time-based analysis.";
$lang["sending_domain"]["form"]["label"]["fallback_return_path"] = "Enable fallback Return-Path";
$lang["sending_domain"]["form"]["label"]["fallback_return_path_description"] = "Enables a fallback return-path when the custom bounce domain fails authentication or is disabled. If disabled, the primary domain will be used instead of the fallback domain.";
$lang["sending_domain"]["form"]["label"]["fallback_domain"] = "Fallback domain";
$lang["sending_domain"]["form"]["label"]["fallback_domain_description"] = "This domain will be used in the return-path when the custom bounce domain is disabled or failed.";
$lang["sending_domain"]["form"]["label"]["disable_send_unauthenticated_description"] = "Prevents emails from being sent using domains that have not passed authentication checks, ensuring compliance and security.";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_dkim_description"] = "It disables the option to change the default DKIM selector for the sending domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_prefix_description"] = "It disables the option to modify the default prefix for the tracking domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_default_bounce_description"] = "It disables the option to change the default prefix for the custom bounce domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_dkim_keys_download_description"] = "It disables the option to download the DKIM key pair for the sending domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_regenerate_dkim_discription"] = "It disables the option to regenerate the DKIM key pair for the sending domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_cname_tracking_description"] = "It disables the \"CNAME\" option for the tracking domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_htaccess_tracking_description"] = "It disables the \".htaccess\" option for the tracking domains.";
$lang["sending_domain"]["form"]["label"]["disable_users_cloak_tracking_description"] = "It disables the \"cloak\" option for the tracking domains.";
$lang["sending_domain"]["form"]["label"]["overwrite_tracking_domain_with_primary_description"] = "It replaces the primary domain with a randomly selected domain from the comma-separated list provided below. The selected domain will be used as the CNAME target for tracking domains, helping to distribute tracking links across multiple domains for improved performance and flexibility.";
$lang["success_message"]["saved_successfully"] = "Settings have been updated successfully.";
$lang["alert_confirm"]["domains_ownership"] = "Are you sure you want to mark all sending domains as verified?";
$lang["alert_warning"]["primary_domain"] = "This domain is restricted and cannot be used as a primary domain. Try another domain!";
$lang["alert_warning"]["folder_not_found"] = "The folder doesn't exist.";
$lang["alert_warning"]["folder_permission_error"] = "The folder doesn't have recursive writable (0777) permissions.";
$lang["confirmation"] = "Confirmation";
$lang["first_name"] = "First Name";
$lang["verify_domains"] = "Verify Domains";
$lang["alert_confirm"]["idle_timeout"] = "Session expiring shortly";
$lang["alert_confirm"]["before_logout"] = "Your session is about to expire due to inactivity. Click on <b>Stay Connected</b> button to keep the session alive!";
$lang["security"]["form"]["label"]["delete_export_file"] = "Delete exported files after";
$lang["security"]["form"]["label"]["delete_export_file_description"] = "Enables the automatic deletion of exported files after a specified time interval, helping manage storage and maintain system performance and security.";
$lang["para"]["database_backup"] = "Schedule database backup to run Daily, Weekly and Monthly.";
$lang["monday"] = "Mon";
$lang["tuesday"] = "Tue";
$lang["wednesday"] = "Wed";
$lang["thursday"] = "Thu";
$lang["friday"] = "Fri";
$lang["saturday"] = "Sat";
$lang["sun"] = "Sun";
$lang["action"]["click_here"] = "Click Here";
$lang["heading"]["contact"] = "Contact Info";
$lang["button"]["submit"] = "Submit";
$lang["success_message"]["key_generated"] = "The DKIM keys have been generated.";
$lang["modal"]["database_backup"]["enabling_description"] = "Enabling this feature will alter some tables and it may take several hours for larger databases. We suggest you take a full backup of your database for the safer side before enabling this option.";
$lang["modal"]["button"]["close"] = "Close";
$lang["modal"]["button"]["proceed"] = "Proceed";
$lang["modal"]["title_database_backup"] = "Database backup is suggested";
$lang["contacts"]["form"]["label"]["md5_suppression"] = "MD5 hashed email support for suppression";
$lang["contacts"]["form"]["label"]["disable_editemail"] = "Disable email address modification for the contacts";
$lang["contacts"]["form"]["label"]["disable_editemail_decription"] = "It will disable the textbox of the contact's email address for any modification. It's useful when you don't want the email address to be changed.";
$lang["contacts"]["form"]["label"]["force_doubleopt_webform"] = "Force double opt-in for web forms";
$lang["contacts"]["form"]["label"]["md5_suppression_description"] = "Enables the import of MD5 hashed email addresses for suppression purposes. This is useful when you only have a list of MD5 hashed emails that need to be suppressed.";
$lang["contacts"]["form"]["label"]["force_doubleopt_webform_description"] = "When enabled, subscribers who submit web forms will receive a confirmation email, requiring them to confirm their subscription to complete the process.";
$lang["contacts"]["form"]["rocket_import_default_mode_option"]["normal_l"] = "Regular";
$lang["contacts"]["form"]["rocket_import_default_mode_option"]["rocket_l"] = "Rocket";
$lang["sending_domain"]["form"]["alert_message"]["note_bold"] = "Note:";
$lang["secutity"]["form"]["alert_message"]["note_text_changing_driver"] = "Changing the driver will log out all currently connected users, including yourself.";
$lang["log"]["form"]["delete_user_logs_help_text"]["days_t"] = "Days";
$lang["broadcast"]["form"]["sender_info"]["custom"] = "Custom";
$lang["broadcast"]["form"]["sender_info"]["sending"] = "Sending Node";
$lang["broadcast"]["form"]["sender_info"]["contact"] = "Contact List";
$lang["sending_domain"]["form"]["button"]["verify"] = "Verify";
$lang["sending_domain"]["table_data"]["txt"] = "TXT";
$lang["sending_domain"]["table_heading"]["host"] = "Host";
$lang["sending_domain"]["table_heading"]["type"] = "Type";
$lang["sending_domain"]["table_heading"]["value"] = "Value";
$lang["sending_domain"]["record_txt"]["txt_para"] = "Add the following 'TXT' record";
$lang["sending_domain"]["form"]["alert_message"]["content_dns_domain"] = "Login to the DNS zone of your domain";
$lang["sending_domain"]["form"]["alert_message"]["content_and_entry"] = "and add the following entry.";
$lang["sending_domain"]["form"]["link"]["generate_key"] = "Generate keys";
$lang["sending_domain"]["form"]["link"]["regenerate_key"] = "Regenerate keys";
$lang["sending_domain"]["form"]["label"]["size_bits"] = "Key size in bits";
$lang["sending_domain"]["form"]["label"]["fallback_dkim"] = "Fallback DKIM domain";
$lang["sending_domain"]["form"]["label"]["fallback_selector"] = "Fallback DKIM selector";
$lang["sending_domain"]["form"]["widget_label"]["fallback_dkim_heading"] = "Fallback DKIM Settings";
$lang["sending_domain"]["form"]["label"]["enable_dkim_label"] = "Enable fallback DKIM";
$lang["sending_domain"]["form"]["alert_message"]["tip"] = "Tip:";
$lang["sending_domain"]["form"]["alert_message"]["start_dkim"] = "Fallback DKIM is";
$lang["sending_domain"]["form"]["alert_message"]["off"] = "Off";
$lang["sending_domain"]["form"]["alert_message"]["end_dkim"] = "Consider enabling this option to ensure outgoing emails remain signed, even if DKIM is disabled for the sending domain.";
$lang["sending_domain"]["form"]["alert_message"]["intellectual_text"] = "Smart selection for tracking domain is currently";
$lang["sending_domain"]["form"]["alert_message"]["end_consider_para"] = "Consider enabling it to ensure email hyperlinks remain functional when email tracking is active, but the custom tracking domain is disabled.";
$lang["sending_domain"]["form"]["label"]["overwrite_tracking_domain_with_primary"] = "Random selection of primary domain for tracking";
$lang["sending_domain"]["form"]["label"]["disable_users_cloak_tracking"] = "Disable cloak option for the tracking domain";
$lang["sending_domain"]["form"]["label"]["disable_users_htaccess_tracking"] = "Disable .htacess option for the tracking domain";
$lang["sending_domain"]["form"]["label"]["disable_users_cname_tracking"] = "Disable CNAME option for the tracking domain";
$lang["sending_domain"]["form"]["label"]["disable_users_regenerate_dkim"] = "Disable regenerating the DKIM Keys";
$lang["sending_domain"]["form"]["label"]["disable_users_dkim_keys_download"] = "Disable downloading the DKIM Keys";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_default_bounce"] = "Disable default prefix editing for custom bounce domain";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_prefix"] = "Disable default prefix editing for tracking domains";
$lang["sending_domain"]["form"]["label"]["disable_users_edit_dkim"] = "Disable default DKIM selector editing for sending domains";
$lang["sending_domain"]["form"]["label"]["disable_send_unauthenticated"] = "Disable sending from unauthenticated domains";
$lang["sending_domain"]["form"]["label"]["php_redirect"] = "PHP file name for tracking domain cloaking method";
$lang["sending_domain"]["form"]["label"]["php_redirect_description"] = "Specifies the name of the cloaking PHP file that will be generated for download. Users will place this file in the root folder of the hosting where the tracking domain is hosted.";
$lang["sending_domain"]["form"]["confirmation_option"]["leave_existing_domains"] = "<b>Do Nothing: </b>Keep the existing sending domains verification statuses as they are.";
$lang["sending_domain"]["form"]["confirmation_option"]["set_existing_domain"] = "<b>Doesn't Require Verification: </b>Set existing sending domains as verified.";
$lang["sending_domain"]["form"]["bounce_method_option"]["route_bounce_server"] = "Route to a bounce server";
$lang["sending_domain"]["form"]["bounce_method_option"]["label_pop_imap"] = "POP/IMAP";
$lang["sending_domain"]["form"]["label"]["bounce_method_description"] = "As you have ESP license so it allows you to enable custom bounce domains for your users, allowing them to set up an MX record and point it to your bounce server.";
$lang["sending_domain"]["form"]["label"]["bounce_method"] = "Bounce processing method";
$lang["sending_domain"]["form"]["alert_message"]["dig_code"] = "dig";
$lang["sending_domain"]["form"]["alert_message"]["your_server_install"] = "needs to be installed on your server in order to make it work.";
$lang["mail"]["form"]["label"]["feedback_id_gmail"] = "Insert Gmail Feedback-ID header";
$lang["mail"]["form"]["label"]["feedback_id_gmail_description"] = "Adds the Gmail-specific Feedback-ID header to outgoing emails to help Gmail identify and track feedback loops, improving email deliverability and spam handling.";
$lang["old_little_txt"] = "Old";
$lang["core_small_txt"] = "(core)";
$lang["new_little_txt"] = "New";
$lang["modular_small_txt"] = "(modular)";
$lang["general"]["form"]["label"]["support_email"] = "Support email";
$lang["general"]["form"]["label"]["support_email_description"] = "Displays this email address to users for support-related inquiries.";
$lang["general"]["form"]["label"]["maximum_contact_limit"] = "Maximum contacts limit";
$lang["general"]["form"]["label"]["maximum_contact_limit_description"] = "Defines the maximum number of contacts allowed across the entire system.";
$lang["error_message"]["domain_verification_error"] = "Domain verification has failed.";
$lang["success_message"]["domain_verification_successfull"] = "Domain has been verified successfully.";
$lang["success_message"]["md5_disable_successfull"] = "MD5 hashing has been disabled successfully.";
$lang["success_message"]["md5_enables_successfull"] = "MD5 hashing has been enabled successfully.";
$lang["contacts"]["form_heading"] = "Contacts Setting";
$lang["module"]["para_dummy_text"] = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy.";
$lang["modules"]["label_search"] = "Contact Search";
$lang["modules"]["label_helpdesk"] = "Helpdesk Support";
$lang["modules"]["label_split"] = "Split Tests";
$lang["contacts_import_export"] = "Import/Export Contacts";
$lang["contact"]["list_group"] = "Contact List Groups";
$lang["modules_custom"]["label"] = "Custom Fields";
$lang["label_campaign_editor"] = "Campaign Editor";
$lang["campaign_scheduling_label"] = "Campaign Scheduling";
$lang["label_bounce_handle"] = "Bounce Handling";
$lang["image_file_label"] = "Image/File Gallery";
$lang["modules_label_statistics"] = "Statistics";
$lang["modules_label_security"] = "Security";
$lang["modules_label_maintenance_m"] = "Maintenance Mode";
$lang["modules_label_auto_upgrade"] = "Auto Upgrade";
$lang["modules_label_segments"] = "Segments";
$lang["modules_label_suppression"] = "Suppression Management";
$lang["modules_label_masking"] = "Masking/Sending Domains";
$lang["modules_spintags_label"] = "Spintax";
$lang["modules_autoresponders_label"] = "Autoresponders";
$lang["modules_dynamic_label"] = "Dynamic Content Tags";
$lang["modules_website_label"] = "Website Forms";
$lang["modules_feedback_label"] = "Feedback Loops";
$lang["modules_email_t_label"] = "Email Templates";
$lang["modules_multi_t_label"] = "Multi Threading";
$lang["modules_siteaddress_label"] = "Allow Site Address in Sender Domain / SMTP";
$lang["modules_Dashboard_d_label"] = "Dashboard Disclaimer";
$lang["modules_heading_para"] = "Heading";
$lang["showaddons_available_span"] = "Available Addons";
$lang["showaddons_campaigns_d_para"] = "Campaigns+ Addons Description";
$lang["showaddons_campaigns_addons_span"] = "Campaigns+ Addons";
$lang["showaddons_all_addons_action"] = "All Addons";
$lang["showaddons_purchased_action"] = "Purchased";
$lang["showaddons_available_action"] = "Available";
$lang["showaddons_email_builder_heading"] = "Drag & Drop Email Builder";
$lang["showaddons_price_bold"] = "Price:";
$lang["showaddons"]["dummy_data"] = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker.";
$lang["showaddons"]["action_learn"] = "Learn More";
$lang["showaddons"]["action_buy_addon"] = "Buy Addon";
$lang["showaddons"]["span_purchased"] = "Purchased";
$lang["showaddons_emojis_heading"] = "Emojis";
$lang["showaddons_powermta_heading"] = "PowerMTA Integration";
$lang["showaddons_white_labeling_heading"] = "White Labeling";
$lang["showaddons_campaigns_pixel_heading"] = "Campaigns+ Pixel";
$lang["upgrade"]["tittle_upgrade"] = "Upgrade";
$lang["upgrade_campaigns_latest_para"] = "Upgrade Campaigns+ to latest available version.";
$lang["upgrade_version_heading"] = "Upgrade Version";
$lang["upgrade_update_version_th"] = "Update Version Detail";
$lang["upgrade_description_td"] = "Description";
$lang["upgrade_old_version_td"] = "Old Version";
$lang["upgrade_available_version_td"] = "Available Version";
$lang["upgrade_last_update_td"] = "Last Update";
$lang["upgrade_campaign_adminpannel_td"] = "Campaign Admin Panel";
$lang["upgrade_campaign_plus_td"] = "Campaign";
$lang["upgrade_new_versionupdate_td"] = "New Version Update";
$lang["upgrade_update_version_td"] = "Update Version";
$lang["upgrade_latest_version_td"] = "You have the latest version of Campaign, Your Current Version:";
$lang["upgrade_detail_action_td"] = "Detail";
$lang["upgrade_current_version_action_td"] = "Current Version";
$lang["upgrade_version_process_td"] = "Upgrade Version process";
$lang["upgrade_download_zip_td"] = "Download Zip";
$lang["upgrade_downloading_div"] = "Downloading";
$lang["upgrade_zip_downloading"] = "Zip Downloaded";
$lang["upgrade_extract_zip_td"] = "Extract Zip";
$lang["upgrade_extracting_div"] = "Extracting";
$lang["upgrade_zip_extracted"] = "Zip Extracted";
$lang["upgrade_Installation_update_td"] = "Installation Updates";
$lang["upgrade_updating_div"] = "Updating";
$lang["upgrade_files_updated_div"] = "Files Updated";
$lang["upgrade_update_sql_td"] = "Update SQL";
$lang["upgrade_sql_updated_div"] = "SQL Updated";
$lang["upgrade_remove_old_files_td"] = "Remove Old Version Files";
$lang["upgrade_removed_old_files_div"] = "Old Version Files Removed";
$lang["upgrade_removing_old_files_div"] = "Removing Old Version Files";
$lang["upgrade_successfully_updated"] = "successfully updated to";
$lang["security"]["form"]["session_storage_option"]["file"] = "File-based";
$lang["security"]["form"]["session_storage_option"]["db"] = "Database";
$lang["Broadcast"]["form"]["open_click_rate"] = "Metric calculation reference for statistics";
$lang["Broadcast"]["form"]["open_click_rate_desc"] = "Choose the reference point for calculating key metrics like opens, clicks, bounces, and spam complaints.";
$lang["Broadcast"]["form"]["campaign_audience"] = "Campaign audience";
$lang["Broadcast"]["form"]["emails_sent"] = "Emails sent";
$lang["Broadcast"]["form"]["emails_delivered"] = "Emails delivered";
$lang["suppression"]["contacts"]["suppress_system_limit_title"] = "Limit suppressed domains";
$lang["integrations"]["form"]["label"]["gmail_api"] = "Gmail OAuth email relay";
$lang["integrations"]["form"]["label"]["gmail_api_help"] = "Connect Gmail accounts to send emails directly through " . $lang["variables"]["site_title"] . ".";
$lang["integrations"]["form"]["label"]["client_secret_credentials"] = "Client Secret Credentials";
$lang["integrations"]["form"]["label"]["client_secret_credentials_help"] = "Paste the client secret credentials obtained from the Google Cloud Console. These credentials authorize " . $lang["variables"]["site_title"] . " to access your Gmail account securely.";
$lang["sending_domain"]["form"]["label"]["use_secure_url"] = "Use Secure URL ";
$lang["sending_domain"]["form"]["label"]["use_secure_url_description"] = "Enable this to use HTTPS for all links in your emailsEnable this to use HTTPS for all links in your emails.";
$lang["broadcast"]["form"]["label"]["unsubscribe_text"] = "Custom unsubscribe content";
$lang["broadcast"]["form"]["label"]["unsubscribe_text_description"] = "Enable this option to customize the default Unsubscribe text with your own message or content. While Mumara will still generate and embed the unsubscribe link for the variable (%%unsubscribelink%%) automatically, the custom content you provide will ensure the text aligns with your branding, offering a more tailored and cohesive presentation in your emails. Moreover, all other variables are supported, including spintax, dynamic tags, profile fields, etc.";
$lang["broadcast"]["form"]["label"]["unsubscribe_html"] = "Unsubscribe Content (HTML supported)";
$lang["broadcast"]["form"]["label"]["unsubscribe_html_description"] = "Enter custom content for your unsubscribe message, with support for HTML formatting. This allows you to design a more engaging and branded unsubscribe section, including links, images, or styling elements, while ensuring the unsubscribe link is still functional.";
$lang["broadcast"]["form"]["allowed_extensions"] = "Allowed Extensions";
$lang["broadcast"]["form"]["allowed_extensions_description"] = "Only selected files will allowed to be attached";
$lang["broadcast"]["form"]["allowed_extensions_msg"] = "Error: Invalid File Format!";
$lang["broadcast"]["form"]["list_allowed_extensions_msg"] = "Error: The file format is not valid.<br>Supported file formats include,";
$lang["sending_domain"]["form"]["label"]["check_default_age"] = "Use default value";
$lang["sending_domain"]["form"]["label"]["check_default_age_description"] = "Use default value";
$lang["sending_domain"]["form"]["label"]["check_domain_eligibily"] = "Check Domain Eligibility";
$lang["sending_domain"]["form"]["label"]["check_domain_eligibily_description"] = "Check Domain Eligibility";
$lang["sending_domain"]["form"]["label"]["check_domain_age"] = "Check for Domain Age";
$lang["sending_domain"]["form"]["label"]["check_domain_blacklist"] = "Check for Blacklist";
$lang["sending_domain"]["form"]["label"]["eligibal_domain_age_days"] = "Eligible Domain Age in Days";
$lang["sending_domain"]["form"]["label"]["eligibal_domain_age_days_description"] = "Use Default Age is older than description";
$lang["sending_domain"]["form"]["label"]["api_key"] = "API Key";
$lang["sending_domain"]["form"]["label"]["api_key_description"] = "API Key";
$lang["sending_domain"]["form"]["label"]["api_key_help"] = "If you don't have the API Key contact Mumara";
$lang["sending_domain"]["form"]["error_message"]["error_domain_age_api_key"] = "Enter Domain Age and API Key";
$lang["sending_domain"]["form"]["error_message"]["error_domain_api_key"] = "Enter Domain API Key";
$lang["sending_domain"]["form"]["error_message"]["error_domain_age"] = "Enter Domain age";
$lang["sending_domain"]["form"]["supported_tld_msg"] = "Error: TLD not supported";
$lang["sending_domain"]["form"]["supported_tld"] = "Supported TLDs";
$lang["sending_domain"]["form"]["supported_tld_desc"] = "Enter full list of all TLDs";
$lang["email_global_footer"]["required"] = "Footer is required";
$lang["email_global_header"]["required"] = "Header is required";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
