<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {

        if (!Schema::hasColumn('dynamic_content_tags' , 'deleted_at')) {
            Schema::table('dynamic_content_tags', function (Blueprint $table) {
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('dynamic_content_tags' , 'deleted_at')) {
            Schema::table('dynamic_content_tags', function (Blueprint $table) {
                $table->dropSoftDeletes();
            });
        }
    }
};
