<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $broadcastPermission = \App\Models\Permission::where('route','broadcasts.index')->first();
        if(!is_null($broadcastPermission))
            addChildPermission('Copy Broadcast Template','1','web','0','0','all','4','broadcast.templates_clone',$broadcastPermission->id,'broadcast_templates_clone');
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'broadcasts||broadcast/{id}/edit||broadcast/add||broadcast/add/{id}||broadcast/templates/select||broadcast/add-new||broadcast/predefined-templates/{id}/edit||broadcasts/predefined-templates||broadcasts/predefined-templates||broadcast/predefined-template/{id}/clone' WHERE `mainmenu`.`link` = 'broadcasts.index';");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'broadcasts||broadcast/{id}/edit||broadcast/add||broadcast/add/{id}||broadcast/schedule||spintags||dynamictags||dynamictag/{id}/edit||drips||drips/*||drip/group/view||drip/group/{id}/edit||drip/group/add||drip/add||splittests||splittest/{id}/edit||splittest/add||schedule/new/*||spintag/add||dynamictag/add||scheduled||broadcasts/schedule||spintag/{id}/edit||broadcast/create/{id}||drip/{id}/edit||scheduled/{type?}||campaign/evergreen||campaign/evergreen/{id}||campaign/evergreen/edit/{id}||spintag/templates||spintag/template/add||spintag/template/{id}/edit||dynamictag/templates||dynamictag/template/{id}/edit||dynamictag/template/add||dynamictag/template/{id}/use||broadcast/predefined-templates/{id}/edit||broadcasts/predefined-templates||broadcasts/predefined-templates||broadcast/predefined-template/{id}/clone' WHERE `mainmenu`.`id` = 3;");
        $roles = \App\Models\Role::where('id', '!=', 1)->where('type','web')->pluck('id')->toArray();
        $broadcastCopyPermission = \App\Models\Permission::where('permission','broadcast_templates_clone')->first();
        if(!is_null($broadcastCopyPermission)) {
            foreach ($roles as $role) {
                $permission_role = \App\Models\RolePermission::where('role_id', $role)->first();
                if (!is_null($permission_role)) {
                    \App\Models\RolePermission::firstOrCreate(['role_id' => $role, 'permission_id' => $broadcastCopyPermission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\Permission::where('route','broadcast.templates_clone')->delete();
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'broadcasts||broadcast/{id}/edit||broadcast/add||broadcast/add/{id}||broadcast/templates/select||broadcast/add-new' WHERE `mainmenu`.`link` = 'broadcasts.index';");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'broadcasts||broadcast/{id}/edit||broadcast/add||broadcast/add/{id}||broadcast/schedule||spintags||dynamictags||dynamictag/{id}/edit||drips||drips/*||drip/group/view||drip/group/{id}/edit||drip/group/add||drip/add||splittests||splittest/{id}/edit||splittest/add||schedule/new/*||spintag/add||dynamictag/add||scheduled||broadcasts/schedule||spintag/{id}/edit||broadcast/create/{id}||drip/{id}/edit||scheduled/{type?}||campaign/evergreen||campaign/evergreen/{id}||campaign/evergreen/edit/{id}||spintag/templates||spintag/template/add||spintag/template/{id}/edit||dynamictag/templates||dynamictag/template/{id}/edit||dynamictag/template/add||dynamictag/template/{id}/use' WHERE `mainmenu`.`id` = 3;");
        $broadcastCopyPermission = \App\Models\Permission::where('permission','broadcast_templates_clone')->first();
        if(!is_null($broadcastCopyPermission))
            \App\Models\RolePermission::where('permission_id',$broadcastCopyPermission->id)->delete();

    }
};
