<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('domain_maskings', 'recheck_timer'))
        {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->timestamp('recheck_timer')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('domain_maskings', 'recheck_timer'))
        {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->dropColumn('recheck_timer');
            });
         }
    }
};
