<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $getCustomFields = DB::table('custom_fields')
        ->select('id', 'user_id','is_default')
        ->get();
        foreach ($getCustomFields as $getCustoms) {
            $user_id =isset($getCustoms->user_id) ? $getCustoms->user_id: 2 ;
            $users = DB::table('users')
            ->where('id', $user_id)
            ->select('is_client')->first();
            if(!empty($users))
            {
                $customField = DB::table('custom_fields')->where('id', $getCustoms->id)->first();
                 if($getCustoms->is_default==1){
                    if ($customField && $customField->group_id === null) {
                        if ($users->is_client == 1) {
                            $group_default_id = DB::table('groups')
                            ->where('user_id', $user_id)
                            ->where('section_id',5)
                            ->where('name', 'Default')
                            ->value('id');
                        }
                        else {
                            $group_default_id = DB::table('groups')
                            ->where('user_id', 2)
                            ->where('section_id',5)
                            ->where('name', 'Default')
                            ->value('id');
                        }
                        DB::table('custom_fields')
                        ->where('id', $getCustoms->id)
                        ->update(['group_id' => $group_default_id]);
                    }
                }
                else {               
                    if ($customField && $customField->group_id === null) {
                        if ($users->is_client == 1) {
                            $group_unsorted_id = DB::table('groups')
                                ->where('user_id', $user_id)
                                ->where('section_id',5)
                                ->where('name', 'Unsorted')
                                ->value('id');        
                        } else {
                            $group_unsorted_id = DB::table('groups')
                                ->where('user_id', 2)
                                ->where('section_id',5)
                                ->where('name', 'Unsorted')
                                ->value('id');                  
                        }
                        DB::table('custom_fields')
                        ->where('id', $getCustoms->id)
                        ->update(['group_id' => $group_unsorted_id]);
                    }
                }
            }          
            else {
               
                    $group_default_id = DB::table('groups')
                    ->where('user_id', 2)
                    ->where('section_id',5)
                    ->where('name', 'Default')
                    ->value('id');
                DB::table('custom_fields')
                ->where('id', $getCustoms->id)
                ->update(['group_id' => $group_default_id]);
            }

            }
    
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
