<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'gravatar_last_updated')) {
            Schema::table('users', function (Blueprint $table) {
                 $table->timestamp('gravatar_last_updated')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'gravatar_last_updated')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('gravatar_last_updated');
            });
        }
    }
};
