<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('custom_fields', 'language')) {
            Schema::table('custom_fields', function (Blueprint $table) {
                $table->string('language')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (!Schema::hasColumn('custom_fields', 'language')) {
            Schema::table('custom_fields', function (Blueprint $table) {
                $table->dropColumn('language');
            });
        }
    }
};
