<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('evergreen_campaigns', 'rss_status')) {
            Schema::table('evergreen_campaigns', function (Blueprint $table) {
                $table->tinyInteger('rss_status')->nullable();
            });
        }
        if (!Schema::hasColumn('evergreen_campaigns', 'rss_tags')) {
            Schema::table('evergreen_campaigns', function (Blueprint $table) {
                $table->text('rss_tags')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('evergreen_campaigns', 'rss_status')) {
            Schema::table('evergreen_campaigns', function (Blueprint $table) {
                $table->dropColumn('rss_status');
            });
        }
        if (Schema::hasColumn('evergreen_campaigns', 'rss_tags')) {
            Schema::table('evergreen_campaigns', function (Blueprint $table) {
                $table->dropColumn('rss_tags');
            });
        }
    }
};
