<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try { 
            if (!Schema::hasColumn('alter_tables', 'require_pause')) {
                Schema::table('alter_tables', function (Blueprint $table) {
                    $table->tinyInteger('require_pause')->default(0);
                });
            } 
            if (!Schema::hasColumn('campaign_schedule_logs', 'status_code') and !Schema::hasColumn('campaign_schedule_logs', 'mta_response_code')) {
                DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` ADD `mta_response_code` VARCHAR(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;", "0", NULL, 3, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);');
            }
    
            if (Schema::hasColumn('campaign_schedule_logs', 'status_code') and !Schema::hasColumn('campaign_schedule_logs', 'mta_response_code') ) {
                DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` CHANGE `status_code` `mta_response_code` VARCHAR(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;", "0", NULL, "3", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);');
            }
            if (!Schema::hasColumn('campaign_schedule_logs', 'status_reason') and !Schema::hasColumn('campaign_schedule_logs', 'mta_error')) {
                DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` ADD `mta_error` TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;", "0", NULL, "3", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);');
            }
            if (Schema::hasColumn('campaign_schedule_logs', 'status_reason') and !Schema::hasColumn('campaign_schedule_logs', 'mta_error')) {
               DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` CHANGE `status_reason` `mta_error` TEXT CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NULL DEFAULT NULL;", "0", NULL, "3", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);'); 
            }
    
            if (!Schema::hasColumn('campaign_schedule_logs', 'subject')) {
                DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` ADD `subject` TEXT NULL DEFAULT NULL;", "0", NULL, "3", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);'); 
            }
            if (Schema::hasColumn('campaign_schedule_logs', 'recipient_email')) {
                DB::statement('INSERT INTO `alter_tables` (`id`, `name`, `type`, `query`, `status`, `fields`, `try_attempts`, `created_at`, `updated_at`, `execute_at`, `require_pause`) VALUES (NULL, "campaign_log", "query", "ALTER TABLE `campaign_schedule_logs` DROP `recipient_email`;", "0", NULL, "3", CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, NULL , 1);'); 
            }
        } catch( Exception $e) {
            echo $e->getMessage();
        }
        

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (!Schema::hasColumn('alter_tables', 'require_pause')) {
            Schema::table('alter_tables', function (Blueprint $table) {
                $table->dropColumn('require_pause');
            });
        }
        
        if (Schema::hasColumn('campaign_schedule_logs', 'mta_response_code')) {
            Schema::table("campaign_schedule_logs", function (Blueprint $table) {
                $table->renameColumn('mta_response_code', 'status_code');
            });

           
        }
        if (Schema::hasColumn('campaign_schedule_logs', 'status_reason')) {
            Schema::table("campaign_schedule_logs", function (Blueprint $table) {
                $table->renameColumn('status_reason', 'mta_error');
            });
        }

        if (Schema::hasColumn('campaign_schedule_logs', 'recipient_email')) {
            Schema::table("campaign_schedule_logs", function (Blueprint $table) {
                $table->string('recipient_email')->nullable();
            });
        }
    }
};
